/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth;

import de.sciss.osc.Channel;
import de.sciss.osc.PacketCodec;
import de.sciss.osc.TCP;
import de.sciss.osc.TCP$;
import de.sciss.osc.Transport;
import de.sciss.osc.UDP;
import de.sciss.osc.UDP$;
import de.sciss.synth.Client;
import de.sciss.synth.Server;
import de.sciss.synth.message.ServerCodec$;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.sys.package$;

public interface ServerPlatform {
    public static String defaultProgram$(ServerPlatform $this) {
        return $this.defaultProgram();
    }

    default public String defaultProgram() {
        return (String)package$.MODULE$.props().get("SC_HOME").orElse(ServerPlatform::defaultProgram$$anonfun$1).fold(ServerPlatform::defaultProgram$$anonfun$2, (Function1 & Serializable)home -> new File((String)home, "scsynth").getPath());
    }

    public static InetSocketAddress mkAddress$(ServerPlatform $this, Server.Config config) {
        return $this.mkAddress(config);
    }

    default public InetSocketAddress mkAddress(Server.Config config) {
        return new InetSocketAddress(config.host(), config.port());
    }

    public static boolean isLocal$(ServerPlatform $this, InetSocketAddress addr) {
        return $this.isLocal(addr);
    }

    default public boolean isLocal(InetSocketAddress addr) {
        InetAddress host = addr.getAddress();
        return host.isLoopbackAddress() || host.isSiteLocalAddress();
    }

    public static Tuple2 prepareConnection$(ServerPlatform $this, Server.Config serverConfig, Client.Config clientConfig) {
        return $this.prepareConnection(serverConfig, clientConfig);
    }

    default public Tuple2<InetSocketAddress, Channel.Bidi> prepareConnection(Server.Config serverConfig, Client.Config clientConfig) {
        Channel.Bidi bidi;
        InetSocketAddress serverAddr = new InetSocketAddress(serverConfig.host(), serverConfig.port());
        InetSocketAddress clientAddr = (InetSocketAddress)clientConfig.addr().getOrElse(() -> ServerPlatform.$anonfun$1(serverAddr));
        Transport transport = serverConfig.transport();
        if (UDP$.MODULE$.equals(transport)) {
            UDP.ConfigBuilder cfg = UDP.Config$.MODULE$.apply();
            cfg.localSocketAddress_$eq(clientAddr);
            cfg.codec_$eq((PacketCodec)ServerCodec$.MODULE$);
            cfg.bufferSize_$eq(65536);
            bidi = UDP.Client$.MODULE$.apply((SocketAddress)serverAddr, UDP.Config$.MODULE$.build(cfg));
        } else if (TCP$.MODULE$.equals(transport)) {
            TCP.ConfigBuilder cfg = TCP.Config$.MODULE$.apply();
            cfg.codec_$eq((PacketCodec)ServerCodec$.MODULE$);
            cfg.localSocketAddress_$eq(clientAddr);
            cfg.bufferSize_$eq(65536);
            bidi = TCP.Client$.MODULE$.apply((SocketAddress)serverAddr, TCP.Config$.MODULE$.build(cfg));
        } else {
            Transport other = transport;
            throw new IllegalArgumentException("Unsupported OSC transport " + other);
        }
        Channel.Bidi client = bidi;
        return Tuple2$.MODULE$.apply((Object)serverAddr, (Object)client);
    }

    private static Option defaultProgram$$anonfun$1() {
        return package$.MODULE$.env().get((Object)"SC_HOME");
    }

    private static String defaultProgram$$anonfun$2() {
        return "scsynth";
    }

    private static InetSocketAddress $anonfun$1(InetSocketAddress serverAddr$1) {
        InetAddress a = serverAddr$1.getAddress();
        return a.isLoopbackAddress() || a.isAnyLocalAddress() ? new InetSocketAddress("127.0.0.1", 0) : new InetSocketAddress(InetAddress.getLocalHost(), 0);
    }
}

