/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth;

import de.sciss.audiofile.AudioFileType;
import de.sciss.audiofile.SampleFormat;
import de.sciss.model.Model;
import de.sciss.numbers.RichInt$;
import de.sciss.osc.Browser$;
import de.sciss.osc.Dump;
import de.sciss.osc.Message;
import de.sciss.osc.Packet;
import de.sciss.osc.TCP$;
import de.sciss.osc.Transport;
import de.sciss.osc.UDP$;
import de.sciss.synth.BufferManager;
import de.sciss.synth.Client;
import de.sciss.synth.Group;
import de.sciss.synth.Import$;
import de.sciss.synth.NodeManager;
import de.sciss.synth.Server$;
import de.sciss.synth.Server$Config$;
import de.sciss.synth.Server$ConfigBuilder$;
import de.sciss.synth.Server$Counts$;
import de.sciss.synth.ServerLike;
import de.sciss.synth.message.Responder;
import de.sciss.synth.message.ServerQuit$;
import de.sciss.synth.message.StatusReply;
import de.sciss.synth.message.Sync;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.Builder;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface Server
extends ServerLike,
Model<Update> {
    public Client.Config clientConfig();

    public Group rootNode();

    public Group defaultGroup();

    public NodeManager nodeManager();

    public BufferManager bufManager();

    public boolean isLocal();

    public boolean isConnected();

    public boolean isRunning();

    public boolean isOffline();

    public int nextNodeId();

    public int nextSyncId();

    public int allocControlBus(int var1);

    public int allocAudioBus(int var1);

    public void freeControlBus(int var1);

    public void freeAudioBus(int var1);

    public int allocBuffer(int var1);

    public void freeBuffer(int var1);

    public void $bang(Packet var1);

    public <A> Future<A> $bang$bang(Packet var1, Duration var2, PartialFunction<Message, A> var3);

    public static Duration $bang$bang$default$2$(Server $this) {
        return $this.$bang$bang$default$2();
    }

    default public <A> Duration $bang$bang$default$2() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(6)).seconds();
    }

    public StatusReply counts();

    public double sampleRate();

    public Condition condition();

    public void startAliveThread(float var1, float var2, int var3);

    public static float startAliveThread$default$1$(Server $this) {
        return $this.startAliveThread$default$1();
    }

    default public float startAliveThread$default$1() {
        return 0.25f;
    }

    public static float startAliveThread$default$2$(Server $this) {
        return $this.startAliveThread$default$2();
    }

    default public float startAliveThread$default$2() {
        return 0.25f;
    }

    public static int startAliveThread$default$3$(Server $this) {
        return $this.startAliveThread$default$3();
    }

    default public int startAliveThread$default$3() {
        return 25;
    }

    public void stopAliveThread();

    public void queryCounts();

    public Sync syncMsg();

    public void dumpOSC(Dump var1, Function1<Packet, Object> var2);

    public static Dump dumpOSC$default$1$(Server $this) {
        return $this.dumpOSC$default$1();
    }

    default public Dump dumpOSC$default$1() {
        return Dump.Text$.MODULE$;
    }

    public static Function1 dumpOSC$default$2$(Server $this) {
        return $this.dumpOSC$default$2();
    }

    default public Function1<Packet, Object> dumpOSC$default$2() {
        return (Function1 & Serializable)_$1 -> true;
    }

    public void dumpInOSC(Dump var1, Function1<Packet, Object> var2);

    public static Dump dumpInOSC$default$1$(Server $this) {
        return $this.dumpInOSC$default$1();
    }

    default public Dump dumpInOSC$default$1() {
        return Dump.Text$.MODULE$;
    }

    public static Function1 dumpInOSC$default$2$(Server $this) {
        return $this.dumpInOSC$default$2();
    }

    default public Function1<Packet, Object> dumpInOSC$default$2() {
        return (Function1 & Serializable)_$2 -> true;
    }

    public void dumpOutOSC(Dump var1, Function1<Packet, Object> var2);

    public static Dump dumpOutOSC$default$1$(Server $this) {
        return $this.dumpOutOSC$default$1();
    }

    default public Dump dumpOutOSC$default$1() {
        return Dump.Text$.MODULE$;
    }

    public static Function1 dumpOutOSC$default$2$(Server $this) {
        return $this.dumpOutOSC$default$2();
    }

    default public Function1<Packet, Object> dumpOutOSC$default$2() {
        return (Function1 & Serializable)_$3 -> true;
    }

    public void quit();

    public ServerQuit$ quitMsg();

    public void dispose();

    public void addResponder(Responder var1);

    public void removeResponder(Responder var1);

    public static String toString$(Server $this) {
        return $this.toString();
    }

    default public String toString() {
        return "<" + this.name() + ">";
    }

    public static interface Condition
    extends Update {
    }

    public static final class Config
    implements ConfigLike {
        private final String program;
        private final int controlBusChannels;
        private final int audioBusChannels;
        private final int outputBusChannels;
        private final int blockSize;
        private final int sampleRate;
        private final int audioBuffers;
        private final int maxNodes;
        private final int maxSynthDefs;
        private final int memorySize;
        private final int wireBuffers;
        private final int randomSeeds;
        private final boolean loadSynthDefs;
        private final Option machPortName;
        private final int verbosity;
        private final List plugInsPaths;
        private final Option restrictedPath;
        private final String host;
        private final int port;
        private final Transport transport;
        private final Option inputStreamsEnabled;
        private final Option outputStreamsEnabled;
        private final Option deviceNames;
        private final Option deviceName;
        private final int inputBusChannels;
        private final int hardwareBlockSize;
        private final boolean zeroConf;
        private final int maxLogins;
        private final Option sessionPassword;
        private final String nrtCommandPath;
        private final Option nrtInputPath;
        private final String nrtOutputPath;
        private final AudioFileType nrtHeaderFormat;
        private final SampleFormat nrtSampleFormat;

        public static void addCommonArgs(ConfigLike configLike, Builder<String, Object> builder) {
            Server$Config$.MODULE$.addCommonArgs(configLike, builder);
        }

        public static ConfigBuilder apply() {
            return Server$Config$.MODULE$.apply();
        }

        public static Config build(ConfigBuilder configBuilder) {
            return Server$Config$.MODULE$.build(configBuilder);
        }

        public Config(String program, int controlBusChannels, int audioBusChannels, int outputBusChannels, int blockSize, int sampleRate, int audioBuffers, int maxNodes, int maxSynthDefs, int memorySize, int wireBuffers, int randomSeeds, boolean loadSynthDefs, Option<Tuple2<String, String>> machPortName, int verbosity, List<String> plugInsPaths, Option<String> restrictedPath, String host, int port, Transport transport, Option<String> inputStreamsEnabled, Option<String> outputStreamsEnabled, Option<Tuple2<String, String>> deviceNames, Option<String> deviceName, int inputBusChannels, int hardwareBlockSize, boolean zeroConf, int maxLogins, Option<String> sessionPassword, String nrtCommandPath, Option<String> nrtInputPath, String nrtOutputPath, AudioFileType nrtHeaderFormat, SampleFormat nrtSampleFormat) {
            this.program = program;
            this.controlBusChannels = controlBusChannels;
            this.audioBusChannels = audioBusChannels;
            this.outputBusChannels = outputBusChannels;
            this.blockSize = blockSize;
            this.sampleRate = sampleRate;
            this.audioBuffers = audioBuffers;
            this.maxNodes = maxNodes;
            this.maxSynthDefs = maxSynthDefs;
            this.memorySize = memorySize;
            this.wireBuffers = wireBuffers;
            this.randomSeeds = randomSeeds;
            this.loadSynthDefs = loadSynthDefs;
            this.machPortName = machPortName;
            this.verbosity = verbosity;
            this.plugInsPaths = plugInsPaths;
            this.restrictedPath = restrictedPath;
            this.host = host;
            this.port = port;
            this.transport = transport;
            this.inputStreamsEnabled = inputStreamsEnabled;
            this.outputStreamsEnabled = outputStreamsEnabled;
            this.deviceNames = deviceNames;
            this.deviceName = deviceName;
            this.inputBusChannels = inputBusChannels;
            this.hardwareBlockSize = hardwareBlockSize;
            this.zeroConf = zeroConf;
            this.maxLogins = maxLogins;
            this.sessionPassword = sessionPassword;
            this.nrtCommandPath = nrtCommandPath;
            this.nrtInputPath = nrtInputPath;
            this.nrtOutputPath = nrtOutputPath;
            this.nrtHeaderFormat = nrtHeaderFormat;
            this.nrtSampleFormat = nrtSampleFormat;
        }

        @Override
        public String program() {
            return this.program;
        }

        @Override
        public int controlBusChannels() {
            return this.controlBusChannels;
        }

        @Override
        public int audioBusChannels() {
            return this.audioBusChannels;
        }

        @Override
        public int outputBusChannels() {
            return this.outputBusChannels;
        }

        @Override
        public int blockSize() {
            return this.blockSize;
        }

        @Override
        public int sampleRate() {
            return this.sampleRate;
        }

        @Override
        public int audioBuffers() {
            return this.audioBuffers;
        }

        @Override
        public int maxNodes() {
            return this.maxNodes;
        }

        @Override
        public int maxSynthDefs() {
            return this.maxSynthDefs;
        }

        @Override
        public int memorySize() {
            return this.memorySize;
        }

        @Override
        public int wireBuffers() {
            return this.wireBuffers;
        }

        @Override
        public int randomSeeds() {
            return this.randomSeeds;
        }

        @Override
        public boolean loadSynthDefs() {
            return this.loadSynthDefs;
        }

        @Override
        public Option<Tuple2<String, String>> machPortName() {
            return this.machPortName;
        }

        @Override
        public int verbosity() {
            return this.verbosity;
        }

        @Override
        public List<String> plugInsPaths() {
            return this.plugInsPaths;
        }

        @Override
        public Option<String> restrictedPath() {
            return this.restrictedPath;
        }

        @Override
        public String host() {
            return this.host;
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public Transport transport() {
            return this.transport;
        }

        @Override
        public Option<String> inputStreamsEnabled() {
            return this.inputStreamsEnabled;
        }

        @Override
        public Option<String> outputStreamsEnabled() {
            return this.outputStreamsEnabled;
        }

        @Override
        public Option<Tuple2<String, String>> deviceNames() {
            return this.deviceNames;
        }

        @Override
        public Option<String> deviceName() {
            return this.deviceName;
        }

        @Override
        public int inputBusChannels() {
            return this.inputBusChannels;
        }

        @Override
        public int hardwareBlockSize() {
            return this.hardwareBlockSize;
        }

        @Override
        public boolean zeroConf() {
            return this.zeroConf;
        }

        @Override
        public int maxLogins() {
            return this.maxLogins;
        }

        @Override
        public Option<String> sessionPassword() {
            return this.sessionPassword;
        }

        @Override
        public String nrtCommandPath() {
            return this.nrtCommandPath;
        }

        @Override
        public Option<String> nrtInputPath() {
            return this.nrtInputPath;
        }

        @Override
        public String nrtOutputPath() {
            return this.nrtOutputPath;
        }

        @Override
        public AudioFileType nrtHeaderFormat() {
            return this.nrtHeaderFormat;
        }

        @Override
        public SampleFormat nrtSampleFormat() {
            return this.nrtSampleFormat;
        }

        public String toString() {
            return "Server.Config";
        }
    }

    public static final class ConfigBuilder
    implements ConfigLike {
        private String program = Server$.MODULE$.defaultProgram();
        private int controlBusChannelsVar = 4096;
        private int audioBusChannelsVar = 128;
        private int outputBusChannelsVar = 8;
        private int blockSizeVar = 64;
        private int sampleRateVar = 0;
        private int audioBuffersVar = 1024;
        private int maxNodes = 1024;
        private int maxSynthDefs = 1024;
        private int memorySize = 65536;
        private int wireBuffers = 256;
        private int randomSeeds = 64;
        private boolean loadSynthDefs = false;
        private Option machPortName = None$.MODULE$;
        private int verbosity = 0;
        private List plugInsPaths = package$.MODULE$.Nil();
        private Option restrictedPath = None$.MODULE$;
        private String host = "127.0.0.1";
        private int port = 57110;
        private Transport transport = UDP$.MODULE$;
        private Option inputStreamsEnabled = None$.MODULE$;
        private Option outputStreamsEnabled = None$.MODULE$;
        private Option<String> deviceNameVar = Option$.MODULE$.empty();
        private Option<Tuple2<String, String>> deviceNamesVar = Option$.MODULE$.empty();
        private int inputBusChannelsVar = 8;
        private int hardwareBlockSize = 0;
        private boolean zeroConf = false;
        private int maxLogins = 64;
        private Option sessionPassword = None$.MODULE$;
        private String nrtCommandPath = "";
        private Option nrtInputPath = None$.MODULE$;
        private String nrtOutputPath = "";
        private AudioFileType nrtHeaderFormat = AudioFileType.AIFF$.MODULE$;
        private SampleFormat nrtSampleFormat = SampleFormat.Float$.MODULE$;

        public static ConfigBuilder apply(Config config) {
            return Server$ConfigBuilder$.MODULE$.apply(config);
        }

        @Override
        public String program() {
            return this.program;
        }

        public void program_$eq(String x$1) {
            this.program = x$1;
        }

        @Override
        public int controlBusChannels() {
            return this.controlBusChannelsVar;
        }

        public void controlBusChannels_$eq(int value) {
            Predef$.MODULE$.require(value > 0 && RichInt$.MODULE$.isPowerOfTwo$extension(Import$.MODULE$.intNumberWrapper(value)));
            this.controlBusChannelsVar = value;
        }

        @Override
        public int audioBusChannels() {
            return this.audioBusChannelsVar;
        }

        public void audioBusChannels_$eq(int value) {
            Predef$.MODULE$.require(value > 0 && RichInt$.MODULE$.isPowerOfTwo$extension(Import$.MODULE$.intNumberWrapper(value)));
            this.audioBusChannelsVar = value;
        }

        @Override
        public int outputBusChannels() {
            return this.outputBusChannelsVar;
        }

        public void outputBusChannels_$eq(int value) {
            Predef$.MODULE$.require(value >= 0);
            this.outputBusChannelsVar = value;
        }

        @Override
        public int blockSize() {
            return this.blockSizeVar;
        }

        public void blockSize_$eq(int value) {
            Predef$.MODULE$.require(value > 0 && RichInt$.MODULE$.isPowerOfTwo$extension(Import$.MODULE$.intNumberWrapper(value)));
            this.blockSizeVar = value;
        }

        @Override
        public int sampleRate() {
            return this.sampleRateVar;
        }

        public void sampleRate_$eq(int value) {
            Predef$.MODULE$.require(value >= 0);
            this.sampleRateVar = value;
        }

        @Override
        public int audioBuffers() {
            return this.audioBuffersVar;
        }

        public void audioBuffers_$eq(int value) {
            Predef$.MODULE$.require(value > 0 && RichInt$.MODULE$.isPowerOfTwo$extension(Import$.MODULE$.intNumberWrapper(value)));
            this.audioBuffersVar = value;
        }

        @Override
        public int maxNodes() {
            return this.maxNodes;
        }

        public void maxNodes_$eq(int x$1) {
            this.maxNodes = x$1;
        }

        @Override
        public int maxSynthDefs() {
            return this.maxSynthDefs;
        }

        public void maxSynthDefs_$eq(int x$1) {
            this.maxSynthDefs = x$1;
        }

        @Override
        public int memorySize() {
            return this.memorySize;
        }

        public void memorySize_$eq(int x$1) {
            this.memorySize = x$1;
        }

        @Override
        public int wireBuffers() {
            return this.wireBuffers;
        }

        public void wireBuffers_$eq(int x$1) {
            this.wireBuffers = x$1;
        }

        @Override
        public int randomSeeds() {
            return this.randomSeeds;
        }

        public void randomSeeds_$eq(int x$1) {
            this.randomSeeds = x$1;
        }

        @Override
        public boolean loadSynthDefs() {
            return this.loadSynthDefs;
        }

        public void loadSynthDefs_$eq(boolean x$1) {
            this.loadSynthDefs = x$1;
        }

        @Override
        public Option<Tuple2<String, String>> machPortName() {
            return this.machPortName;
        }

        public void machPortName_$eq(Option<Tuple2<String, String>> x$1) {
            this.machPortName = x$1;
        }

        @Override
        public int verbosity() {
            return this.verbosity;
        }

        public void verbosity_$eq(int x$1) {
            this.verbosity = x$1;
        }

        @Override
        public List<String> plugInsPaths() {
            return this.plugInsPaths;
        }

        public void plugInsPaths_$eq(List<String> x$1) {
            this.plugInsPaths = x$1;
        }

        @Override
        public Option<String> restrictedPath() {
            return this.restrictedPath;
        }

        public void restrictedPath_$eq(Option<String> x$1) {
            this.restrictedPath = x$1;
        }

        @Override
        public String host() {
            return this.host;
        }

        public void host_$eq(String x$1) {
            this.host = x$1;
        }

        @Override
        public int port() {
            return this.port;
        }

        public void port_$eq(int x$1) {
            this.port = x$1;
        }

        @Override
        public Transport transport() {
            return this.transport;
        }

        public void transport_$eq(Transport x$1) {
            this.transport = x$1;
        }

        @Override
        public Option<String> inputStreamsEnabled() {
            return this.inputStreamsEnabled;
        }

        public void inputStreamsEnabled_$eq(Option<String> x$1) {
            this.inputStreamsEnabled = x$1;
        }

        @Override
        public Option<String> outputStreamsEnabled() {
            return this.outputStreamsEnabled;
        }

        public void outputStreamsEnabled_$eq(Option<String> x$1) {
            this.outputStreamsEnabled = x$1;
        }

        @Override
        public Option<String> deviceName() {
            return this.deviceNameVar;
        }

        public void deviceName_$eq(Option<String> value) {
            this.deviceNameVar = value;
            if (value.isDefined()) {
                this.deviceNamesVar = None$.MODULE$;
            }
        }

        @Override
        public Option<Tuple2<String, String>> deviceNames() {
            return this.deviceNamesVar;
        }

        public void deviceNames_$eq(Option<Tuple2<String, String>> value) {
            this.deviceNamesVar = value;
            if (value.isDefined()) {
                this.deviceNameVar = None$.MODULE$;
            }
        }

        @Override
        public int inputBusChannels() {
            return this.inputBusChannelsVar;
        }

        public void inputBusChannels_$eq(int value) {
            Predef$.MODULE$.require(value >= 0);
            this.inputBusChannelsVar = value;
        }

        @Override
        public int hardwareBlockSize() {
            return this.hardwareBlockSize;
        }

        public void hardwareBlockSize_$eq(int x$1) {
            this.hardwareBlockSize = x$1;
        }

        @Override
        public boolean zeroConf() {
            return this.zeroConf;
        }

        public void zeroConf_$eq(boolean x$1) {
            this.zeroConf = x$1;
        }

        @Override
        public int maxLogins() {
            return this.maxLogins;
        }

        public void maxLogins_$eq(int x$1) {
            this.maxLogins = x$1;
        }

        @Override
        public Option<String> sessionPassword() {
            return this.sessionPassword;
        }

        public void sessionPassword_$eq(Option<String> x$1) {
            this.sessionPassword = x$1;
        }

        @Override
        public String nrtCommandPath() {
            return this.nrtCommandPath;
        }

        public void nrtCommandPath_$eq(String x$1) {
            this.nrtCommandPath = x$1;
        }

        @Override
        public Option<String> nrtInputPath() {
            return this.nrtInputPath;
        }

        public void nrtInputPath_$eq(Option<String> x$1) {
            this.nrtInputPath = x$1;
        }

        @Override
        public String nrtOutputPath() {
            return this.nrtOutputPath;
        }

        public void nrtOutputPath_$eq(String x$1) {
            this.nrtOutputPath = x$1;
        }

        @Override
        public AudioFileType nrtHeaderFormat() {
            return this.nrtHeaderFormat;
        }

        public void nrtHeaderFormat_$eq(AudioFileType x$1) {
            this.nrtHeaderFormat = x$1;
        }

        @Override
        public SampleFormat nrtSampleFormat() {
            return this.nrtSampleFormat;
        }

        public void nrtSampleFormat_$eq(SampleFormat x$1) {
            this.nrtSampleFormat = x$1;
        }

        public void pickPort() {
            Predef$.MODULE$.require(this.isLocal());
            Transport transport = this.transport();
            if (UDP$.MODULE$.equals(transport)) {
                DatagramSocket tmp = new DatagramSocket();
                this.port_$eq(tmp.getLocalPort());
                tmp.close();
            } else if (TCP$.MODULE$.equals(transport)) {
                ServerSocket tmp = new ServerSocket(0);
                this.port_$eq(tmp.getLocalPort());
                tmp.close();
            } else if (Browser$.MODULE$.equals(transport)) {
                this.port_$eq(57120);
            } else {
                throw new MatchError((Object)transport);
            }
        }

        public boolean isLocal() {
            InetAddress hostAddr = InetAddress.getByName(this.host());
            return hostAddr.isLoopbackAddress() || hostAddr.isSiteLocalAddress() || hostAddr.isAnyLocalAddress();
        }

        public Config build() {
            int minAudioBuses = this.inputBusChannels() + this.outputBusChannels() + 1;
            int audioBusesAdjust = this.audioBusChannels() >= minAudioBuses ? this.audioBusChannels() : RichInt$.MODULE$.nextPowerOfTwo$extension(Import$.MODULE$.intNumberWrapper(minAudioBuses));
            return new Config(this.program(), this.controlBusChannels(), audioBusesAdjust, this.outputBusChannels(), this.blockSize(), this.sampleRate(), this.audioBuffers(), this.maxNodes(), this.maxSynthDefs(), this.memorySize(), this.wireBuffers(), this.randomSeeds(), this.loadSynthDefs(), this.machPortName(), this.verbosity(), this.plugInsPaths(), this.restrictedPath(), this.host(), this.port(), this.transport(), this.inputStreamsEnabled(), this.outputStreamsEnabled(), this.deviceNames(), this.deviceName(), this.inputBusChannels(), this.hardwareBlockSize(), this.zeroConf(), this.maxLogins(), this.sessionPassword(), this.nrtCommandPath(), this.nrtInputPath(), this.nrtOutputPath(), this.nrtHeaderFormat(), this.nrtSampleFormat());
        }

        public void read(Config config) {
            this.program_$eq(config.program());
            this.controlBusChannels_$eq(config.controlBusChannels());
            this.audioBusChannels_$eq(config.audioBusChannels());
            this.outputBusChannels_$eq(config.outputBusChannels());
            this.blockSize_$eq(config.blockSize());
            this.sampleRate_$eq(config.sampleRate());
            this.audioBuffers_$eq(config.audioBuffers());
            this.maxNodes_$eq(config.maxNodes());
            this.maxSynthDefs_$eq(config.maxSynthDefs());
            this.memorySize_$eq(config.memorySize());
            this.wireBuffers_$eq(config.wireBuffers());
            this.randomSeeds_$eq(config.randomSeeds());
            this.loadSynthDefs_$eq(config.loadSynthDefs());
            this.machPortName_$eq(config.machPortName());
            this.verbosity_$eq(config.verbosity());
            this.plugInsPaths_$eq(config.plugInsPaths());
            this.restrictedPath_$eq(config.restrictedPath());
            this.host_$eq(config.host());
            this.port_$eq(config.port());
            this.transport_$eq(config.transport());
            this.inputStreamsEnabled_$eq(config.inputStreamsEnabled());
            this.outputStreamsEnabled_$eq(config.outputStreamsEnabled());
            this.deviceNames_$eq(config.deviceNames());
            this.deviceName_$eq(config.deviceName());
            this.inputBusChannels_$eq(config.inputBusChannels());
            this.hardwareBlockSize_$eq(config.hardwareBlockSize());
            this.zeroConf_$eq(config.zeroConf());
            this.maxLogins_$eq(config.maxLogins());
            this.sessionPassword_$eq(config.sessionPassword());
            this.nrtCommandPath_$eq(config.nrtCommandPath());
            this.nrtInputPath_$eq(config.nrtInputPath());
            this.nrtOutputPath_$eq(config.nrtOutputPath());
            this.nrtHeaderFormat_$eq(config.nrtHeaderFormat());
            this.nrtSampleFormat_$eq(config.nrtSampleFormat());
        }
    }

    public static interface ConfigLike {
        public String program();

        public int controlBusChannels();

        public int audioBusChannels();

        public int outputBusChannels();

        public int blockSize();

        public int sampleRate();

        public int audioBuffers();

        public int maxNodes();

        public int maxSynthDefs();

        public int memorySize();

        public int wireBuffers();

        public int randomSeeds();

        public boolean loadSynthDefs();

        public Option<Tuple2<String, String>> machPortName();

        public int verbosity();

        public List<String> plugInsPaths();

        public Option<String> restrictedPath();

        public String host();

        public int port();

        public Transport transport();

        public Option<String> inputStreamsEnabled();

        public Option<String> outputStreamsEnabled();

        public Option<String> deviceName();

        public Option<Tuple2<String, String>> deviceNames();

        public int inputBusChannels();

        public int hardwareBlockSize();

        public boolean zeroConf();

        public int maxLogins();

        public Option<String> sessionPassword();

        public String nrtCommandPath();

        public Option<String> nrtInputPath();

        public String nrtOutputPath();

        public AudioFileType nrtHeaderFormat();

        public SampleFormat nrtSampleFormat();

        public static List toRealtimeArgs$(ConfigLike $this) {
            return $this.toRealtimeArgs();
        }

        default public List<String> toRealtimeArgs() {
            return Server$Config$.MODULE$.toRealtimeArgs(this);
        }

        public static List toNonRealtimeArgs$(ConfigLike $this) {
            return $this.toNonRealtimeArgs();
        }

        default public List<String> toNonRealtimeArgs() {
            return Server$Config$.MODULE$.toNonRealtimeArgs(this);
        }

        public static int internalBusIndex$(ConfigLike $this) {
            return $this.internalBusIndex();
        }

        default public int internalBusIndex() {
            return this.outputBusChannels() + this.inputBusChannels();
        }
    }

    public static final class Counts
    implements Update,
    Product,
    Serializable {
        private final StatusReply c;

        public static Counts apply(StatusReply statusReply) {
            return Server$Counts$.MODULE$.apply(statusReply);
        }

        public static Counts fromProduct(Product product) {
            return Server$Counts$.MODULE$.fromProduct(product);
        }

        public static Counts unapply(Counts counts) {
            return Server$Counts$.MODULE$.unapply(counts);
        }

        public Counts(StatusReply c) {
            this.c = c;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Counts)) return false;
            Counts counts = (Counts)object;
            StatusReply statusReply = this.c();
            StatusReply statusReply2 = counts.c();
            if (statusReply != null) {
                if (!statusReply.equals(statusReply2)) return false;
                return true;
            }
            if (statusReply2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Counts;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Counts";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "c";
        }

        public StatusReply c() {
            return this.c;
        }

        public Counts copy(StatusReply c) {
            return new Counts(c);
        }

        public StatusReply copy$default$1() {
            return this.c();
        }

        public StatusReply _1() {
            return this.c();
        }
    }

    public static interface Update {
    }
}

