/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth;

import de.sciss.synth.ContiguousBlockAllocator$;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class ContiguousBlockAllocator {
    private final int size;
    private final int pos;
    private final Block[] array;
    private Map<Object, Set<Block>> freed;
    private int top;
    private final Object sync;

    public static int $lessinit$greater$default$2() {
        return ContiguousBlockAllocator$.MODULE$.$lessinit$greater$default$2();
    }

    public ContiguousBlockAllocator(int size, int pos) {
        this.size = size;
        this.pos = pos;
        this.array = new Block[size];
        this.freed = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.top = pos;
        this.sync = new Object();
        this.array[pos] = new Block(this, pos, size - pos);
    }

    public int alloc() {
        return this.alloc(1);
    }

    public int alloc(int n) {
        int n2;
        Object object = this.sync;
        synchronized (object) {
            Block b = this.findAvailable(n);
            n2 = b != null ? this.reserve(b.start(), n, b, null).start() : -1;
        }
        return n2;
    }

    public void free(int address) {
        Object object = this.sync;
        synchronized (object) {
            BoxedUnit boxedUnit;
            Block b = this.array[address];
            if (b != null && b.used()) {
                Block next;
                Block temp;
                b.used_$eq(false);
                this.addToFreed(b);
                Block prev = this.findPrevious(address);
                if (prev != null && !prev.used() && (temp = prev.join(b)) != null) {
                    if (b.start() == this.top) {
                        this.top = temp.start();
                    }
                    this.array[temp.start()] = temp;
                    this.array[b.start()] = null;
                    this.removeFromFreed(prev);
                    this.removeFromFreed(b);
                    if (this.top > temp.start()) {
                        this.addToFreed(temp);
                    }
                    b = temp;
                }
                if ((next = this.findNext(b.start())) != null && !next.used()) {
                    Block temp2 = next.join(b);
                    if (temp2 != null) {
                        if (next.start() == this.top) {
                            this.top = temp2.start();
                        }
                        this.array[temp2.start()] = temp2;
                        this.array[next.start()] = null;
                        this.removeFromFreed(next);
                        this.removeFromFreed(b);
                    }
                    if (this.top > temp2.start()) {
                        this.addToFreed(temp2);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private Block findAvailable(int n) {
        Set set;
        Option option = this.freed.get((Object)BoxesRunTime.boxToInteger((int)n));
        if (option instanceof Some && (set = (Set)((Some)option).value()).nonEmpty()) {
            return (Block)set.head();
        }
        for (Tuple2 entry : this.freed) {
            if (BoxesRunTime.unboxToInt((Object)entry._1()) < n || !((IterableOnceOps)entry._2()).nonEmpty()) continue;
            return (Block)((IterableOps)entry._2()).head();
        }
        if (this.top + n > this.size || this.array[this.top].used()) {
            return null;
        }
        return this.array[this.top];
    }

    private void addToFreed(Block b) {
        Option setO = this.freed.get((Object)BoxesRunTime.boxToInteger((int)b.size()));
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)b.size()));
        this.freed = (Map)this.freed.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, setO.isDefined() ? ((SetOps)setO.get()).$plus((Object)b) : Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Block[]{b}))));
    }

    private void removeFromFreed(Block b) {
        this.freed.get((Object)BoxesRunTime.boxToInteger((int)b.size())).foreach((Function1)(JProcedure1 & Serializable)set -> {
            Set newSet = (Set)set.$minus((Object)b);
            if (newSet.isEmpty()) {
                this.freed = (Map)this.freed.$minus((Object)BoxesRunTime.boxToInteger((int)b.size()));
            } else {
                Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)b.size()));
                this.freed = (Map)this.freed.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)newSet));
            }
        });
    }

    private Block findPrevious(int address) {
        for (int i = address - 1; i >= this.pos; --i) {
            if (this.array[i] == null) continue;
            return this.array[i];
        }
        return null;
    }

    private Block findNext(int address) {
        Block temp = this.array[address];
        if (temp != null) {
            return this.array[temp.start() + temp.size()];
        }
        for (int i = address + 1; i <= this.top; ++i) {
            if (this.array[i] == null) continue;
            return this.array[i];
        }
        return null;
    }

    private Block reserve(int address, int size, Block availBlock, Block prevBlock) {
        Block b;
        Block block = availBlock != null ? availBlock : (b = prevBlock != null ? prevBlock : this.findPrevious(address));
        if (b.start() < address) {
            b = (Block)this.split(b, address - b.start(), false)._2();
        }
        return (Block)this.split(b, size, true)._1();
    }

    private Tuple2<Block, Block> split(Block availBlock, int n, boolean used) {
        Tuple2<Block, Block> result = availBlock.split(n);
        Block newB = (Block)result._1();
        Block leftOver = (Block)result._2();
        newB.used_$eq(used);
        this.removeFromFreed(availBlock);
        if (!used) {
            this.addToFreed(newB);
        }
        this.array[newB.start()] = newB;
        if (leftOver != null) {
            this.array[leftOver.start()] = leftOver;
            if (this.top > leftOver.start()) {
                this.addToFreed(leftOver);
            } else {
                this.top = leftOver.start();
            }
        }
        return result;
    }

    private final class Block {
        private final int start;
        private final int size;
        private boolean used;
        private final ContiguousBlockAllocator $outer;

        public Block(ContiguousBlockAllocator $outer, int start, int size) {
            this.start = start;
            this.size = size;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.used = false;
        }

        public int start() {
            return this.start;
        }

        public int size() {
            return this.size;
        }

        public boolean used() {
            return this.used;
        }

        public void used_$eq(boolean x$1) {
            this.used = x$1;
        }

        public boolean adjoins(Block b) {
            return this.start() < b.start() && this.start() + this.size() >= b.start() || this.start() > b.start() && b.start() + b.size() >= this.start();
        }

        public Block join(Block b) {
            Block block;
            if (this.adjoins(b)) {
                int newStart = package$.MODULE$.min(this.start(), b.start());
                int newSize = package$.MODULE$.max(this.start() + this.size(), b.start() + b.size()) - newStart;
                block = new Block(this.$outer, newStart, newSize);
            } else {
                block = null;
            }
            return block;
        }

        public Tuple2<Block, Block> split(int len) {
            return len < this.size() ? Tuple2$.MODULE$.apply((Object)new Block(this.$outer, this.start(), len), (Object)new Block(this.$outer, this.start() + len, this.size() - len)) : (len == this.size() ? Tuple2$.MODULE$.apply((Object)this, null) : Tuple2$.MODULE$.apply(null, null));
        }

        public final ContiguousBlockAllocator de$sciss$synth$ContiguousBlockAllocator$Block$$$outer() {
            return this.$outer;
        }
    }
}

