/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth;

import de.sciss.audiofile.AudioFileType;
import de.sciss.audiofile.SampleFormat;
import de.sciss.model.impl.ModelImpl;
import de.sciss.optional.Optional$;
import de.sciss.osc.Packet;
import de.sciss.synth.Buffer$;
import de.sciss.synth.BufferManager;
import de.sciss.synth.FillRange;
import de.sciss.synth.FillRange$;
import de.sciss.synth.FillValue;
import de.sciss.synth.Server;
import de.sciss.synth.message.BufferAlloc;
import de.sciss.synth.message.BufferAlloc$;
import de.sciss.synth.message.BufferAllocRead;
import de.sciss.synth.message.BufferAllocRead$;
import de.sciss.synth.message.BufferAllocReadChannel;
import de.sciss.synth.message.BufferAllocReadChannel$;
import de.sciss.synth.message.BufferClose;
import de.sciss.synth.message.BufferClose$;
import de.sciss.synth.message.BufferFill;
import de.sciss.synth.message.BufferFill$;
import de.sciss.synth.message.BufferFree;
import de.sciss.synth.message.BufferFree$;
import de.sciss.synth.message.BufferGen;
import de.sciss.synth.message.BufferGen$;
import de.sciss.synth.message.BufferGen$Cheby$;
import de.sciss.synth.message.BufferGen$Sine1$;
import de.sciss.synth.message.BufferGen$Sine2$;
import de.sciss.synth.message.BufferGen$Sine3$;
import de.sciss.synth.message.BufferGet;
import de.sciss.synth.message.BufferGet$;
import de.sciss.synth.message.BufferGetn;
import de.sciss.synth.message.BufferGetn$;
import de.sciss.synth.message.BufferInfo;
import de.sciss.synth.message.BufferQuery;
import de.sciss.synth.message.BufferQuery$;
import de.sciss.synth.message.BufferRead;
import de.sciss.synth.message.BufferRead$;
import de.sciss.synth.message.BufferReadChannel;
import de.sciss.synth.message.BufferReadChannel$;
import de.sciss.synth.message.BufferSet;
import de.sciss.synth.message.BufferSet$;
import de.sciss.synth.message.BufferSetn;
import de.sciss.synth.message.BufferSetn$;
import de.sciss.synth.message.BufferWrite;
import de.sciss.synth.message.BufferWrite$;
import de.sciss.synth.message.BufferZero;
import de.sciss.synth.message.BufferZero$;
import java.io.Serializable;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;

public final class Buffer
implements ModelImpl<BufferManager.BufferInfo>,
Product,
Serializable {
    private Object de$sciss$model$impl$ModelImpl$$sync;
    private volatile Vector de$sciss$model$impl$ModelImpl$$listeners;
    private final Server server;
    private final int id;
    private boolean released;
    private int numFramesVar;
    private int numChannelsVar;
    private float sampleRateVar;
    private final Object sync;

    public static Buffer apply(Server server) {
        return Buffer$.MODULE$.apply(server);
    }

    public static Buffer apply(Server server, int n) {
        return Buffer$.MODULE$.apply(server, n);
    }

    public static Buffer fromProduct(Product product) {
        return Buffer$.MODULE$.fromProduct(product);
    }

    public static Buffer unapply(Buffer buffer) {
        return Buffer$.MODULE$.unapply(buffer);
    }

    public static Server apply$default$1() {
        return Buffer$.MODULE$.apply$default$1();
    }

    public Buffer(Server server, int id) {
        this.server = server;
        this.id = id;
        ModelImpl.$init$((ModelImpl)this);
        this.released = false;
        this.numFramesVar = -1;
        this.numChannelsVar = -1;
        this.sampleRateVar = 0.0f;
        this.sync = new Object();
        Statics.releaseFence();
    }

    public Object de$sciss$model$impl$ModelImpl$$sync() {
        return this.de$sciss$model$impl$ModelImpl$$sync;
    }

    public Vector de$sciss$model$impl$ModelImpl$$listeners() {
        return this.de$sciss$model$impl$ModelImpl$$listeners;
    }

    public void de$sciss$model$impl$ModelImpl$$listeners_$eq(Vector x$1) {
        this.de$sciss$model$impl$ModelImpl$$listeners = x$1;
    }

    public void de$sciss$model$impl$ModelImpl$_setter_$de$sciss$model$impl$ModelImpl$$sync_$eq(Object x$0) {
        this.de$sciss$model$impl$ModelImpl$$sync = x$0;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.server()));
        n = Statics.mix((int)n, (int)this.id());
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Buffer)) return false;
        Buffer buffer = (Buffer)object;
        if (this.id() != buffer.id()) return false;
        Server server = this.server();
        Server server2 = buffer.server();
        if (server != null) {
            if (!server.equals(server2)) return false;
            return true;
        }
        if (server2 == null) return true;
        return false;
    }

    public boolean canEqual(Object that) {
        return that instanceof Buffer;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Buffer";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        if (0 == n2) {
            object = this._1();
        } else if (1 == n2) {
            object = BoxesRunTime.boxToInteger((int)this._2());
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "server";
        } else if (1 == n2) {
            string = "id";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public Server server() {
        return this.server;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        String info = this.numFramesVar >= 0 ? " : <" + this.numFramesVar + "," + this.numChannelsVar + "," + this.sampleRateVar + ">" : "";
        return "Buffer(" + this.server() + "," + this.id() + ")" + info;
    }

    public int numFrames() {
        return this.numFramesVar;
    }

    public int numChannels() {
        return this.numChannelsVar;
    }

    public float sampleRate() {
        return this.sampleRateVar;
    }

    public void register() {
        this.server().bufManager().register(this);
    }

    public Buffer init(BufferInfo.Data info) {
        this.numFramesVar = info.numFrames();
        this.numChannelsVar = info.numChannels();
        this.sampleRateVar = info.sampleRate();
        return this;
    }

    public void updated(BufferManager.BufferInfo change) {
        Object object = this.sync;
        synchronized (object) {
            BufferInfo.Data info = change.info();
            this.numFramesVar = info.numFrames();
            this.numChannelsVar = info.numChannels();
            this.sampleRateVar = info.sampleRate();
            this.dispatch(change);
        }
    }

    public BufferQuery queryMsg() {
        return BufferQuery$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.id()}));
    }

    public BufferFree freeMsg() {
        return this.freeMsg(Optional$.MODULE$.apply((Option)None$.MODULE$), true);
    }

    public BufferFree freeMsg(Option completion, boolean release) {
        BufferFree bufferFree;
        Object object = this.sync;
        synchronized (object) {
            if (release) {
                this.release();
            }
            bufferFree = BufferFree$.MODULE$.apply(this.id(), (Option<Packet>)Optional$.MODULE$.unapply(completion));
        }
        return bufferFree;
    }

    public Option freeMsg$default$1() {
        return Optional$.MODULE$.apply((Option)None$.MODULE$);
    }

    public boolean freeMsg$default$2() {
        return true;
    }

    public void release() {
        Object object = this.sync;
        synchronized (object) {
            if (this.released) {
                throw package$.MODULE$.error("" + this + " : has already been freed");
            }
            this.server().freeBuffer(this.id());
            this.released = true;
        }
    }

    public BufferClose closeMsg() {
        return this.closeMsg(Optional$.MODULE$.apply((Option)None$.MODULE$));
    }

    public BufferClose closeMsg(Option completion) {
        return BufferClose$.MODULE$.apply(this.id(), (Option<Packet>)Optional$.MODULE$.unapply(completion));
    }

    public Option closeMsg$default$1() {
        return Optional$.MODULE$.apply((Option)None$.MODULE$);
    }

    public BufferAlloc allocMsg(int numFrames, int numChannels, Option completion) {
        BufferAlloc bufferAlloc;
        Object object = this.sync;
        synchronized (object) {
            this.numFramesVar = numFrames;
            this.numChannelsVar = numChannels;
            this.sampleRateVar = (float)this.server().sampleRate();
            bufferAlloc = BufferAlloc$.MODULE$.apply(this.id(), numFrames, numChannels, (Option<Packet>)Optional$.MODULE$.unapply(completion));
        }
        return bufferAlloc;
    }

    public int allocMsg$default$2() {
        return 1;
    }

    public Option allocMsg$default$3() {
        return Optional$.MODULE$.apply((Option)None$.MODULE$);
    }

    public BufferAllocRead allocReadMsg(String path, int startFrame, int numFrames, Option completion) {
        return BufferAllocRead$.MODULE$.apply(this.id(), path, startFrame, numFrames, (Option<Packet>)Optional$.MODULE$.unapply(completion));
    }

    public int allocReadMsg$default$2() {
        return 0;
    }

    public int allocReadMsg$default$3() {
        return -1;
    }

    public Option allocReadMsg$default$4() {
        return Optional$.MODULE$.apply((Option)None$.MODULE$);
    }

    public BufferAllocReadChannel allocReadChannelMsg(String path, int startFrame, int numFrames, Seq<Object> channels, Option completion) {
        return BufferAllocReadChannel$.MODULE$.apply(this.id(), path, startFrame, numFrames, (List<Object>)channels.toList(), (Option<Packet>)Optional$.MODULE$.unapply(completion));
    }

    public int allocReadChannelMsg$default$2() {
        return 0;
    }

    public int allocReadChannelMsg$default$3() {
        return -1;
    }

    public Option allocReadChannelMsg$default$5() {
        return Optional$.MODULE$.apply((Option)None$.MODULE$);
    }

    public BufferRead cueMsg(String path, int startFrame, Option completion) {
        return BufferRead$.MODULE$.apply(this.id(), path, startFrame, this.numFrames(), 0, true, (Option<Packet>)Optional$.MODULE$.unapply(completion));
    }

    public int cueMsg$default$2() {
        return 0;
    }

    public Option cueMsg$default$3() {
        return Optional$.MODULE$.apply((Option)None$.MODULE$);
    }

    public BufferRead readMsg(String path, int fileStartFrame, int numFrames, int bufStartFrame, boolean leaveOpen, Option completion) {
        return BufferRead$.MODULE$.apply(this.id(), path, fileStartFrame, numFrames, bufStartFrame, leaveOpen, (Option<Packet>)Optional$.MODULE$.unapply(completion));
    }

    public int readMsg$default$2() {
        return 0;
    }

    public int readMsg$default$3() {
        return -1;
    }

    public int readMsg$default$4() {
        return 0;
    }

    public boolean readMsg$default$5() {
        return false;
    }

    public Option readMsg$default$6() {
        return Optional$.MODULE$.apply((Option)None$.MODULE$);
    }

    public BufferReadChannel readChannelMsg(String path, int fileStartFrame, int numFrames, int bufStartFrame, boolean leaveOpen, Seq<Object> channels, Option completion) {
        return BufferReadChannel$.MODULE$.apply(this.id(), path, fileStartFrame, numFrames, bufStartFrame, leaveOpen, (List<Object>)channels.toList(), (Option<Packet>)Optional$.MODULE$.unapply(completion));
    }

    public int readChannelMsg$default$2() {
        return 0;
    }

    public int readChannelMsg$default$3() {
        return -1;
    }

    public int readChannelMsg$default$4() {
        return 0;
    }

    public boolean readChannelMsg$default$5() {
        return false;
    }

    public Option readChannelMsg$default$7() {
        return Optional$.MODULE$.apply((Option)None$.MODULE$);
    }

    public BufferSet setMsg(Seq<FillValue> pairs) {
        return BufferSet$.MODULE$.apply(this.id(), pairs);
    }

    public BufferSetn setnMsg(IndexedSeq<Object> values) {
        return BufferSetn$.MODULE$.apply(this.id(), (Seq<Tuple2<Object, IndexedSeq<Object>>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0), values)}));
    }

    public BufferSetn setnMsg(Seq<Tuple2<Object, IndexedSeq<Object>>> pairs) {
        return BufferSetn$.MODULE$.apply(this.id(), pairs);
    }

    public BufferGet getMsg(Seq<Object> indices) {
        return BufferGet$.MODULE$.apply(this.id(), indices);
    }

    public BufferGetn getnMsg(Seq<Range> ranges) {
        return BufferGetn$.MODULE$.apply(this.id(), ranges);
    }

    public BufferFill fillMsg(float value) {
        return BufferFill$.MODULE$.apply(this.id(), (Seq<FillRange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FillRange[]{FillRange$.MODULE$.apply(0, this.numFrames() * this.numChannels(), value)}));
    }

    public BufferFill fillMsg(Seq<FillRange> ranges) {
        return BufferFill$.MODULE$.apply(this.id(), ranges);
    }

    public BufferZero zeroMsg() {
        return this.zeroMsg(Optional$.MODULE$.apply((Option)None$.MODULE$));
    }

    public BufferZero zeroMsg(Option completion) {
        return BufferZero$.MODULE$.apply(this.id(), (Option<Packet>)Optional$.MODULE$.unapply(completion));
    }

    public BufferWrite writeMsg(String path, AudioFileType fileType, SampleFormat sampleFormat, int numFrames, int startFrame, boolean leaveOpen, Option completion) {
        return BufferWrite$.MODULE$.apply(this.id(), path, fileType, sampleFormat, numFrames, startFrame, leaveOpen, (Option<Packet>)Optional$.MODULE$.unapply(completion));
    }

    public AudioFileType writeMsg$default$2() {
        return AudioFileType.AIFF$.MODULE$;
    }

    public SampleFormat writeMsg$default$3() {
        return SampleFormat.Float$.MODULE$;
    }

    public int writeMsg$default$4() {
        return -1;
    }

    public int writeMsg$default$5() {
        return 0;
    }

    public boolean writeMsg$default$6() {
        return false;
    }

    public Option writeMsg$default$7() {
        return Optional$.MODULE$.apply((Option)None$.MODULE$);
    }

    public BufferGen genMsg(BufferGen.Command command) {
        return BufferGen$.MODULE$.apply(this.id(), command);
    }

    public BufferGen sine1Msg(Seq<Object> partials, boolean normalize, boolean wavetable, boolean clear) {
        return this.genMsg(BufferGen$Sine1$.MODULE$.apply(partials, normalize, wavetable, clear));
    }

    public boolean sine1Msg$default$2() {
        return true;
    }

    public boolean sine1Msg$default$3() {
        return true;
    }

    public boolean sine1Msg$default$4() {
        return true;
    }

    public BufferGen sine2Msg(Seq<Tuple2<Object, Object>> partials, boolean normalize, boolean wavetable, boolean clear) {
        return this.genMsg(BufferGen$Sine2$.MODULE$.apply(partials, normalize, wavetable, clear));
    }

    public boolean sine2Msg$default$2() {
        return true;
    }

    public boolean sine2Msg$default$3() {
        return true;
    }

    public boolean sine2Msg$default$4() {
        return true;
    }

    public BufferGen sine3Msg(Seq<Tuple3<Object, Object, Object>> partials, boolean normalize, boolean wavetable, boolean clear) {
        return this.genMsg(BufferGen$Sine3$.MODULE$.apply(partials, normalize, wavetable, clear));
    }

    public boolean sine3Msg$default$2() {
        return true;
    }

    public boolean sine3Msg$default$3() {
        return true;
    }

    public boolean sine3Msg$default$4() {
        return true;
    }

    public BufferGen chebyMsg(Seq<Object> amps, boolean normalize, boolean wavetable, boolean clear) {
        return this.genMsg(BufferGen$Cheby$.MODULE$.apply(amps, normalize, wavetable, clear));
    }

    public boolean chebyMsg$default$2() {
        return true;
    }

    public boolean chebyMsg$default$3() {
        return true;
    }

    public boolean chebyMsg$default$4() {
        return true;
    }

    public Buffer copy(Server server, int id) {
        return new Buffer(server, id);
    }

    public Server copy$default$1() {
        return this.server();
    }

    public int copy$default$2() {
        return this.id();
    }

    public Server _1() {
        return this.server();
    }

    public int _2() {
        return this.id();
    }
}

