/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth;

import de.sciss.synth.AudioBus$;
import de.sciss.synth.Bus;
import de.sciss.synth.Rate;
import de.sciss.synth.Server;
import de.sciss.synth.audio$;
import java.io.Serializable;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;

public final class AudioBus
implements Bus,
Product,
Serializable {
    private boolean released;
    private Object sync;
    private final Server server;
    private final int index;
    private final int numChannels;

    public static AudioBus apply(Server server, int n, int n2) {
        return AudioBus$.MODULE$.apply(server, n, n2);
    }

    public static AudioBus fromProduct(Product product) {
        return AudioBus$.MODULE$.fromProduct(product);
    }

    public static AudioBus unapply(AudioBus audioBus) {
        return AudioBus$.MODULE$.unapply(audioBus);
    }

    public AudioBus(Server server, int index, int numChannels) {
        this.server = server;
        this.index = index;
        this.numChannels = numChannels;
        Bus.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public boolean released() {
        return this.released;
    }

    @Override
    public final Object sync() {
        return this.sync;
    }

    @Override
    public void released_$eq(boolean x$1) {
        this.released = x$1;
    }

    @Override
    public void de$sciss$synth$Bus$_setter_$sync_$eq(Object x$0) {
        this.sync = x$0;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.server()));
        n = Statics.mix((int)n, (int)this.index());
        n = Statics.mix((int)n, (int)this.numChannels());
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof AudioBus)) return false;
        AudioBus audioBus = (AudioBus)object;
        if (this.index() != audioBus.index()) return false;
        if (this.numChannels() != audioBus.numChannels()) return false;
        Server server = this.server();
        Server server2 = audioBus.server();
        if (server != null) {
            if (!server.equals(server2)) return false;
            return true;
        }
        if (server2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof AudioBus;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "AudioBus";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this._2());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this._3());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "server";
                break;
            }
            case 1: {
                string = "index";
                break;
            }
            case 2: {
                string = "numChannels";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    @Override
    public Server server() {
        return this.server;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public int numChannels() {
        return this.numChannels;
    }

    @Override
    public Rate rate() {
        return audio$.MODULE$;
    }

    @Override
    public void free() {
        Object object = this.sync();
        synchronized (object) {
            if (this.released()) {
                throw package$.MODULE$.error("" + this + " : has already been freed");
            }
            this.server().freeAudioBus(this.index());
            this.released_$eq(true);
        }
    }

    public AudioBus copy(Server server, int index, int numChannels) {
        return new AudioBus(server, index, numChannels);
    }

    public Server copy$default$1() {
        return this.server();
    }

    public int copy$default$2() {
        return this.index();
    }

    public int copy$default$3() {
        return this.numChannels();
    }

    public Server _1() {
        return this.server();
    }

    public int _2() {
        return this.index();
    }

    public int _3() {
        return this.numChannels();
    }
}

