/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.lib.protocol.matcher;

import de.sayayi.lib.protocol.Level;
import de.sayayi.lib.protocol.ProtocolMessageMatcher;
import de.sayayi.lib.protocol.TagSelector;
import de.sayayi.lib.protocol.matcher.BooleanMatcher;
import de.sayayi.lib.protocol.matcher.Conjunction;
import de.sayayi.lib.protocol.matcher.Disjunction;
import de.sayayi.lib.protocol.matcher.LevelMatcher;
import de.sayayi.lib.protocol.matcher.MessageMatcher;
import de.sayayi.lib.protocol.matcher.MessageMatcherErrorStrategy;
import de.sayayi.lib.protocol.matcher.MessageMatchers;
import de.sayayi.lib.protocol.matcher.Negation;
import de.sayayi.lib.protocol.matcher.antlr.AbstractAntlr4Compiler;
import de.sayayi.lib.protocol.matcher.antlr.AbstractVocabulary;
import de.sayayi.lib.protocol.matcher.antlr.MessageMatcherBaseListener;
import de.sayayi.lib.protocol.matcher.antlr.MessageMatcherLexer;
import de.sayayi.lib.protocol.matcher.antlr.MessageMatcherParser;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MessageMatcherParser
extends AbstractAntlr4Compiler {
    public static final MessageMatcherParser INSTANCE = new MessageMatcherParser(null, null);
    protected final ClassLoader classLoader;
    protected final Function<String, Level> levelResolver;
    private static final Vocabulary VOC = new AbstractVocabulary(){

        @Override
        protected void addTokens() {
            this.add(1, "'any'", "ANY");
            this.add(2, "'none'", "NONE");
            this.add(3, "'not'", "NOT");
            this.add(4, "'throwable'", "THROWABLE");
            this.add(5, "'tag'", "TAG");
            this.add(6, "'any-of'", "ANY_OF");
            this.add(7, "'all-of'", "ALL_OF");
            this.add(8, "'none-of'", "NONE_OF");
            this.add(9, "'has-param'", "HAS_PARAM");
            this.add(10, "'has-param-value'", "HAS_PARAM_VALUE");
            this.add(11, "'debug'", "DEBUG");
            this.add(12, "'info'", "INFO");
            this.add(13, "'warn'", "WARN");
            this.add(14, "'error'", "ERROR");
            this.add(15, "'level'", "LEVEL");
            this.add(16, "'message'", "MESSAGE");
            this.add(17, "'in-group'", "IN_GROUP");
            this.add(18, "'in-group-regex'", "IN_GROUP_REGEX");
            this.add(19, "'in-root'", "IN_ROOT");
            this.add(20, "'and'", "AND");
            this.add(21, "'or'", "OR");
            this.add(22, "'('", "L_PAREN");
            this.add(23, "')'", "R_PAREN");
            this.add(24, "','", "COMMA");
            this.add(25, "<string>", "STRING");
            this.add(26, "<qualified class name>", "QUALIFIED_CLASS_NAME");
            this.add(27, "<identifier>", "IDENTIFIER");
            this.add(28, "' '", "WS");
        }
    };

    @Contract(pure=true)
    @NotNull
    public MessageMatcher parseMessageMatcher(@NotNull String messageMatcherText) {
        return this.compile(new Lexer(messageMatcherText), x$0 -> new Parser((Lexer)x$0), de.sayayi.lib.protocol.matcher.antlr.MessageMatcherParser::parseMatcher, new Listener(messageMatcherText), ctx -> ctx.matcher);
    }

    @Contract(pure=true)
    @NotNull
    public TagSelector parseTagSelector(@NotNull String tagSelectorText) {
        return this.compile(new Lexer(tagSelectorText), x$0 -> new Parser((Lexer)x$0), de.sayayi.lib.protocol.matcher.antlr.MessageMatcherParser::parseTagSelector, new Listener(tagSelectorText), ctx -> ctx.selector);
    }

    public MessageMatcherParser(ClassLoader classLoader, Function<String, Level> levelResolver) {
        this.classLoader = classLoader;
        this.levelResolver = levelResolver;
    }

    public static final class Service
    implements ProtocolMessageMatcher {
        @NotNull
        public MessageMatcher parseMessageMatcher(@NotNull String messageMatcherExpression) {
            return INSTANCE.parseMessageMatcher(messageMatcherExpression);
        }

        @NotNull
        public TagSelector parseTagSelector(@NotNull String tagSelectorExpression) {
            return INSTANCE.parseTagSelector(tagSelectorExpression);
        }
    }

    private final class Listener
    extends MessageMatcherBaseListener
    implements AbstractAntlr4Compiler.WalkerSupplier {
        private final String matcherText;

        @Override
        @NotNull
        public AbstractAntlr4Compiler.Walker getWalker() {
            return AbstractAntlr4Compiler.Walker.WALK_EXIT_RULES_ONLY;
        }

        @Override
        public void exitParseMatcher(MessageMatcherParser.ParseMatcherContext ctx) {
            ctx.matcher = ctx.compoundMatcher().matcher;
        }

        @Override
        public void exitParseTagSelector(MessageMatcherParser.ParseTagSelectorContext ctx) {
            ctx.selector = ctx.compoundTagSelector().selector.asTagSelector();
        }

        @Override
        public void exitAndMatcher(MessageMatcherParser.AndMatcherContext ctx) {
            ctx.matcher = Conjunction.of((MessageMatcher[])((MessageMatcher[])ctx.compoundMatcher().stream().map(ec -> ec.matcher).toArray(MessageMatcher[]::new)));
        }

        @Override
        public void exitOrMatcher(MessageMatcherParser.OrMatcherContext ctx) {
            ctx.matcher = Disjunction.of((MessageMatcher[])((MessageMatcher[])ctx.compoundMatcher().stream().map(ec -> ec.matcher).toArray(MessageMatcher[]::new)));
        }

        @Override
        public void exitNotMatcher(MessageMatcherParser.NotMatcherContext ctx) {
            MessageMatcher.Junction expr = ctx.compoundMatcher().matcher;
            ctx.matcher = ctx.NOT() != null ? Negation.of((MessageMatcher)expr) : expr;
        }

        @Override
        public void exitToMatcher(MessageMatcherParser.ToMatcherContext ctx) {
            ctx.matcher = ctx.matcherAtom().matcher.asJunction();
        }

        @Override
        public void exitBooleanMatcher(MessageMatcherParser.BooleanMatcherContext ctx) {
            ctx.matcher = ctx.ANY() != null ? BooleanMatcher.ANY : BooleanMatcher.NONE;
        }

        @Override
        public void exitThrowableMatcher(MessageMatcherParser.ThrowableMatcherContext ctx) {
            TerminalNode qualifiedName = ctx.QUALIFIED_CLASS_NAME();
            if (qualifiedName == null) {
                ctx.matcher = MessageMatchers.hasThrowable();
            } else {
                String qualifiedNameText = qualifiedName.getText();
                Class<?> clazz = null;
                try {
                    clazz = MessageMatcherParser.this.classLoader == null ? Class.forName(qualifiedNameText) : Class.forName(qualifiedNameText, false, MessageMatcherParser.this.classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz == null || !Throwable.class.isAssignableFrom(clazz)) {
                    MessageMatcherParser.this.syntaxError(this.matcherText, qualifiedName.getSymbol(), "class not found or not of type Throwable", null);
                }
                ctx.matcher = MessageMatchers.hasThrowable(clazz);
            }
        }

        @Override
        public void exitTagMatcher(MessageMatcherParser.TagMatcherContext ctx) {
            ctx.matcher = ctx.tagMatcherAtom().matcher;
        }

        @Override
        public void exitParamMatcher(MessageMatcherParser.ParamMatcherContext ctx) {
            String paramName = ctx.string().str;
            ctx.matcher = ctx.HAS_PARAM() != null ? MessageMatchers.hasParam((String)paramName) : MessageMatchers.hasParamValue((String)paramName);
        }

        @Override
        public void exitLevelMatcher(MessageMatcherParser.LevelMatcherContext ctx) {
            MessageMatcherParser.LevelSharedContext levelShared = ctx.levelShared();
            ctx.matcher = LevelMatcher.of((Level)(levelShared != null ? levelShared.lvl : ctx.level().lvl));
        }

        @Override
        public void exitMessageMatcher(MessageMatcherParser.MessageMatcherContext ctx) {
            ctx.matcher = MessageMatchers.hasMessage((String)ctx.string().str);
        }

        @Override
        public void exitInGroupMatcher(MessageMatcherParser.InGroupMatcherContext ctx) {
            MessageMatcherParser.StringContext groupName = ctx.string();
            ctx.matcher = groupName == null ? MessageMatchers.inGroup() : (ctx.IN_GROUP() != null ? MessageMatchers.inGroup((String)groupName.str) : MessageMatchers.inGroupRegex((String)groupName.str));
        }

        @Override
        public void exitInRootMatcher(MessageMatcherParser.InRootMatcherContext ctx) {
            ctx.matcher = MessageMatchers.inRoot();
        }

        @Override
        public void exitAndTagSelector(MessageMatcherParser.AndTagSelectorContext ctx) {
            ctx.selector = Conjunction.of((MessageMatcher[])((MessageMatcher[])ctx.compoundTagSelector().stream().map(ec -> ec.selector).toArray(MessageMatcher[]::new)));
        }

        @Override
        public void exitOrTagSelector(MessageMatcherParser.OrTagSelectorContext ctx) {
            ctx.selector = Disjunction.of((MessageMatcher[])((MessageMatcher[])ctx.compoundTagSelector().stream().map(ec -> ec.selector).toArray(MessageMatcher[]::new)));
        }

        @Override
        public void exitNotTagSelector(MessageMatcherParser.NotTagSelectorContext ctx) {
            MessageMatcher.Junction expr = ctx.compoundTagSelector().selector;
            ctx.selector = ctx.NOT() != null ? Negation.of((MessageMatcher)expr) : expr;
        }

        @Override
        public void exitToTagSelector(MessageMatcherParser.ToTagSelectorContext ctx) {
            ctx.selector = ctx.tagSelectorAtom().selector.asJunction();
        }

        @Override
        public void exitTagSelectorAtom(MessageMatcherParser.TagSelectorAtomContext ctx) {
            MessageMatcherParser.TagMatcherAtomContext tagExpression = ctx.tagMatcherAtom();
            ctx.selector = tagExpression != null ? tagExpression.matcher : (ctx.ANY() != null ? BooleanMatcher.ANY : BooleanMatcher.NONE);
        }

        @Override
        public void exitTagMatcherAtom(MessageMatcherParser.TagMatcherAtomContext ctx) {
            MessageMatcherParser.TagNameContext tagName = ctx.tagName();
            if (tagName != null) {
                ctx.matcher = MessageMatchers.hasTag((String)tagName.tag);
            } else {
                List<String> tagNameList = ctx.tagNameList().tags;
                switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
                    case 6: {
                        ctx.matcher = MessageMatchers.hasAnyOf(tagNameList);
                        break;
                    }
                    case 7: {
                        ctx.matcher = MessageMatchers.hasAllOf(tagNameList);
                        break;
                    }
                    case 8: {
                        ctx.matcher = MessageMatchers.hasNoneOf(tagNameList);
                    }
                }
            }
        }

        @Override
        public void exitTagNameList(MessageMatcherParser.TagNameListContext ctx) {
            ctx.tags = ctx.tagName().stream().map(tnc -> tnc.tag).collect(Collectors.toList());
        }

        @Override
        public void exitTagName(MessageMatcherParser.TagNameContext ctx) {
            MessageMatcherParser.StringContext stringContext = ctx.string();
            ctx.tag = stringContext != null ? stringContext.str : ctx.getChild(0).getText();
        }

        @Override
        public void exitLevel(MessageMatcherParser.LevelContext ctx) {
            MessageMatcherParser.LevelSharedContext levelShared = ctx.levelShared();
            if (levelShared != null) {
                ctx.lvl = levelShared.lvl;
            } else {
                MessageMatcherParser.StringContext stringContext = ctx.string();
                String name = stringContext != null ? stringContext.str : ctx.getChild(0).getText();
                try {
                    ctx.lvl = MessageMatcherParser.this.levelResolver == null ? null : MessageMatcherParser.this.levelResolver.apply(name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ctx.lvl == null) {
                    for (Level.Shared level : Level.Shared.values()) {
                        if (!level.name().equalsIgnoreCase(name)) continue;
                        ctx.lvl = level;
                        return;
                    }
                    MessageMatcherParser.this.syntaxError(this.matcherText, ctx, "unknown level '" + name + "'");
                }
            }
        }

        @Override
        public void exitLevelShared(MessageMatcherParser.LevelSharedContext ctx) {
            ctx.lvl = Level.Shared.valueOf((String)ctx.getChild(0).getText().toUpperCase(Locale.ROOT));
        }

        @Override
        public void exitString(MessageMatcherParser.StringContext ctx) {
            char[] str = ctx.STRING().getText().toCharArray();
            StringBuilder s = new StringBuilder();
            int n = str.length - 1;
            for (int i = 1; i < n; ++i) {
                char c = str[i];
                if (c == '\\') {
                    c = str[++i];
                    switch (c) {
                        case 'x': {
                            c = (char)(Character.digit(str[i + 1], 16) * 16 + Character.digit(str[i + 2], 16));
                            i += 2;
                            break;
                        }
                        case 'u': {
                            c = (char)(Character.digit(str[i + 1], 16) * 4096 + Character.digit(str[i + 2], 16) * 256 + Character.digit(str[i + 3], 16) * 16 + Character.digit(str[i + 4], 16));
                            i += 4;
                        }
                    }
                }
                s.append(c);
            }
            ctx.str = s.toString();
        }

        private Listener(String matcherText) {
            this.matcherText = matcherText;
        }
    }

    private static final class Parser
    extends de.sayayi.lib.protocol.matcher.antlr.MessageMatcherParser {
        private Parser(@NotNull Lexer lexer) {
            super((TokenStream)new BufferedTokenStream((TokenSource)lexer));
            this.setErrorHandler(MessageMatcherErrorStrategy.INSTANCE);
        }

        @Override
        public Vocabulary getVocabulary() {
            return VOC;
        }
    }

    private static final class Lexer
    extends MessageMatcherLexer
    implements AbstractAntlr4Compiler.CompilerInputSupplier {
        @NotNull
        private final String matcherText;

        public Lexer(@NotNull String matcherText) {
            super((CharStream)new ANTLRInputStream(matcherText));
            this.matcherText = matcherText;
        }

        @Override
        @NotNull
        public String getCompilerInput() {
            return this.matcherText;
        }

        @Override
        public Vocabulary getVocabulary() {
            return VOC;
        }

        public void notifyListeners(LexerNoViableAltException ex) {
            Token token = this.getTokenFactory().create(this._tokenFactorySourcePair, -3, null, this._channel, this._tokenStartCharIndex, this._input.index(), this._tokenStartLine, this._tokenStartCharPositionInLine);
            this.getErrorListenerDispatch().syntaxError((Recognizer)this, (Object)token, this._tokenStartLine, this._tokenStartCharPositionInLine, "unexpected input at: " + this.getErrorDisplay(token.getText()), (RecognitionException)ex);
        }
    }
}

