/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PageArea {
    final int page;
    private final int x1;
    private final int y1;
    private final int x2;
    private final int y2;

    public PageArea(int page) {
        this.page = page;
        this.x1 = -1;
        this.y1 = -1;
        this.x2 = -1;
        this.y2 = -1;
    }

    public PageArea(int x1, int y1, int x2, int y2) {
        this.checkCoordinates(x1, y1, x2, y2);
        this.page = -1;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public PageArea(int page, int x1, int y1, int x2, int y2) {
        this.checkCoordinates(x1, y1, x2, y2);
        if (page < 1) {
            throw new IllegalArgumentException("Page has to be greater or equal to 1");
        }
        this.page = page;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    private void checkCoordinates(int x1, int y1, int x2, int y2) {
        if (x1 < 0 || x2 < 0 || y1 < 0 || y2 < 0) {
            throw new IllegalArgumentException("Coordinates have to be greater than 0");
        }
        if (x1 > x2 || y1 > y2) {
            throw new IllegalArgumentException("x1 has to be smaller or equal to x2 and y1 has to be smaller or equal to y2");
        }
    }

    public boolean hasPage() {
        return this.page >= 1;
    }

    public boolean hasCoordinates() {
        return this.x1 >= 0;
    }

    public boolean contains(int x, int y) {
        if (this.x1 == -1 && this.y1 == -1 && this.x2 == -1 && this.y2 == -1) {
            return true;
        }
        return x >= this.x1 && x <= this.x2 && y >= this.y1 && y <= this.y2;
    }

    public int getPage() {
        return this.page;
    }

    public int getX1() {
        return this.x1;
    }

    public int getY1() {
        return this.y1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY2() {
        return this.y2;
    }

    public int hashCode() {
        return this.page + 31 * this.x1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PageArea)) {
            return false;
        }
        PageArea pageArea = (PageArea)obj;
        return this.getPage() == pageArea.getPage() && this.getX1() == pageArea.getX1() && this.getY1() == pageArea.getY1() && this.getX2() == pageArea.getX2() && this.getY2() == pageArea.getY2();
    }

    public String asJson() {
        if (this.hasPage()) {
            if (this.hasCoordinates()) {
                return "{\"page\": " + this.page + ", \"x1\": " + this.x1 + ", \"y1\": " + this.y1 + ", \"x2\": " + this.x2 + ", \"y2\": " + this.y2 + "}";
            }
            return "{\"page\": " + this.page + "}";
        }
        return "{\"x1\": " + this.x1 + ", \"y1\": " + this.y1 + ", \"x2\": " + this.x2 + ", \"y2\": " + this.y2 + "}";
    }

    public static String asJsonWithExclusion(Collection<PageArea> pageAreas) {
        return PageArea.asJsonWithExclusion(pageAreas.stream());
    }

    public static String asJsonWithExclusion(Stream<PageArea> pageAreaStream) {
        String json = PageArea.asJson(pageAreaStream);
        return json.isEmpty() ? "exclusions: [\n]" : "exclusions: [\n" + json + "\n]";
    }

    public static String asJson(Collection<PageArea> pageAreas) {
        return PageArea.asJson(pageAreas.stream());
    }

    public static String asJson(Stream<PageArea> pageAreas) {
        return pageAreas.map(PageArea::asJson).collect(Collectors.joining(",\n"));
    }
}

