/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare.cli;

import de.redsix.pdfcompare.CompareResult;
import de.redsix.pdfcompare.CompareResultWithExpectedAndActual;
import de.redsix.pdfcompare.PdfComparator;
import de.redsix.pdfcompare.cli.CliArguments;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliComparator {
    private static final int EQUAL_DOCUMENTS_RESULT_VALUE = 0;
    private static final int UNEQUAL_DOCUMENTS_RESULT_VALUE = 1;
    private static final int ERROR_RESULT_VALUE = 2;
    private int result;
    private CompareResult compareResult;
    private static final Logger LOG = LoggerFactory.getLogger(CliComparator.class);

    public CliComparator(CliArguments cliArguments) {
        if (cliArguments.getExpectedFile().isPresent() && cliArguments.getActualFile().isPresent()) {
            this.result = this.compare(cliArguments.getExpectedFile().get(), cliArguments.getActualFile().get());
            if (cliArguments.getOutputFile().isPresent()) {
                this.compareResult.writeTo(cliArguments.getOutputFile().get());
            }
        }
    }

    public int getResult() {
        return this.result;
    }

    private int compare(String expectedFile, String actualFile) {
        try {
            this.compareResult = new PdfComparator<CompareResultWithExpectedAndActual>(expectedFile, actualFile, new CompareResultWithExpectedAndActual()).compare();
            return this.compareResult.isEqual() ? 0 : 1;
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
            return 2;
        }
    }
}

