/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare.cli;

import de.redsix.pdfcompare.cli.CliArguments;
import de.redsix.pdfcompare.cli.CliArgumentsParseException;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CliArgumentsImpl
implements CliArguments {
    private static final int EXPECTED_FILENAME_INDEX = 0;
    private static final int ACTUAL_FILENAME_INDEX = 1;
    private static final String OUTPUT_OPTION = "o";
    private static final String OUTPUT_LONG_OPTION = "output";
    private static final String HELP_OPTION = "h";
    private static final String HELP_LONG_OPTION = "help";
    private final Options options = new Options();
    private CommandLine commandLine;

    public CliArgumentsImpl(String[] args) {
        this.options.addOption(this.buildOutputOption());
        this.options.addOption(this.buildHelpOption());
        this.process(args);
    }

    @Override
    public Boolean areAvailable() {
        return this.commandLine.getArgList().size() == 2 && this.getExpectedFile().isPresent() && this.getActualFile().isPresent();
    }

    @Override
    public Boolean isHelp() {
        return this.commandLine.hasOption(HELP_OPTION);
    }

    @Override
    public Optional<String> getExpectedFile() {
        return this.getRemainingArgument(0);
    }

    @Override
    public Optional<String> getActualFile() {
        return this.getRemainingArgument(1);
    }

    @Override
    public Optional<String> getOutputFile() {
        if (!this.commandLine.hasOption(OUTPUT_OPTION)) {
            return Optional.empty();
        }
        return Optional.of(this.commandLine.getOptionValue(OUTPUT_OPTION));
    }

    @Override
    public void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("java -jar pdfcompare-x.x.x.jar [EXPECTED] [ACTUAL]", this.options);
    }

    private Option buildOutputOption() {
        return Option.builder((String)OUTPUT_OPTION).argName(OUTPUT_LONG_OPTION).desc("Provide an optional output file for the result").hasArg(true).longOpt(OUTPUT_LONG_OPTION).numberOfArgs(1).required(false).type(String.class).valueSeparator('=').build();
    }

    private Option buildHelpOption() {
        return Option.builder((String)HELP_OPTION).argName(HELP_LONG_OPTION).desc("Displays this text and exit").hasArg(false).longOpt(HELP_LONG_OPTION).numberOfArgs(0).required(false).build();
    }

    private void process(String[] args) {
        try {
            DefaultParser commandLineParser = new DefaultParser();
            this.commandLine = commandLineParser.parse(this.options, args);
        }
        catch (ParseException exception) {
            throw new CliArgumentsParseException((Exception)((Object)exception));
        }
    }

    private Optional<String> getRemainingArgument(int index) {
        if (this.commandLine.getArgList().isEmpty() || this.commandLine.getArgList().size() < index + 1) {
            return Optional.empty();
        }
        return Optional.of((String)this.commandLine.getArgList().get(index));
    }
}

