/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class CompareResult {
    private Map<Integer, BufferedImage> diffImages = new TreeMap<Integer, BufferedImage>();
    private boolean isEqual = true;
    private Collection<Integer> diffPages = new TreeSet<Integer>();
    private boolean hasDifferenceInExclusion = false;

    public boolean writeTo(String filename) {
        try (PDDocument document = new PDDocument();){
            for (Map.Entry<Integer, BufferedImage> entry : this.diffImages.entrySet()) {
                BufferedImage image = entry.getValue();
                PDPage page = new PDPage(new PDRectangle((float)image.getWidth(), (float)image.getHeight()));
                document.addPage(page);
                PDImageXObject imageXObject = LosslessFactory.createFromImage((PDDocument)document, (BufferedImage)image);
                PDPageContentStream contentStream = new PDPageContentStream(document, page);
                Throwable throwable = null;
                try {
                    contentStream.drawImage(imageXObject, 0.0f, 0.0f);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (contentStream == null) continue;
                    if (throwable != null) {
                        try {
                            contentStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    contentStream.close();
                }
            }
            document.save(filename + ".pdf");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.isEqual;
    }

    public void addPage(boolean hasDifferences, boolean hasDifferenceInExclusion, int pageIndex, BufferedImage expectedImage, BufferedImage actualImage, BufferedImage diffImage) {
        this.hasDifferenceInExclusion |= hasDifferenceInExclusion;
        if (hasDifferences) {
            this.isEqual = false;
            this.diffPages.add(pageIndex);
        }
        this.diffImages.put(pageIndex, diffImage);
    }

    public boolean isEqual() {
        return this.isEqual;
    }

    public boolean isNotEqual() {
        return !this.isEqual;
    }

    public boolean hasDifferenceInExclusion() {
        return this.hasDifferenceInExclusion;
    }

    public BufferedImage getDiffImage(int page) {
        return this.diffImages.get(page);
    }

    public int getNumberOfPages() {
        if (this.diffImages.isEmpty()) {
            return 0;
        }
        return Collections.max(this.diffImages.keySet());
    }

    public Collection<Integer> getPagesThatDiffer() {
        return this.diffPages;
    }
}

