/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.BlockingHandler;
import de.redsix.pdfcompare.Environment;
import de.redsix.pdfcompare.FileUtils;
import de.redsix.pdfcompare.ImageWithDimension;
import de.redsix.pdfcompare.InThreadExecutorService;
import de.redsix.pdfcompare.PdfComparator;
import de.redsix.pdfcompare.ResourceCacheWithLimitedImages;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utilities {
    private static final Logger LOG = LoggerFactory.getLogger(Utilities.class);

    public static MemoryUsageSetting getMemorySettings(int bytes) throws IOException {
        return MemoryUsageSetting.setupMixed((long)bytes).setTempDir(FileUtils.createTempDir("PdfBox").toFile());
    }

    public static ExecutorService blockingExecutor(String name, int coreThreads, int maxThreads, int queueCapacity) {
        if (Environment.useParallelProcessing()) {
            return new ThreadPoolExecutor(coreThreads, maxThreads, 3L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(queueCapacity), new NamedThreadFactory(name), new BlockingHandler());
        }
        return new InThreadExecutorService();
    }

    public static ExecutorService blockingExecutor(String name, int threads, int queueCapacity) {
        if (Environment.useParallelProcessing()) {
            return new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(queueCapacity), new NamedThreadFactory(name), new BlockingHandler());
        }
        return new InThreadExecutorService();
    }

    public static void shutdownAndAwaitTermination(ExecutorService executor, String executorName) {
        if (executor != null) {
            executor.shutdown();
            try {
                int timeout = 15;
                TimeUnit unit = TimeUnit.MINUTES;
                if (!executor.awaitTermination(15L, unit)) {
                    LOG.error("Awaiting Shutdown of Executor '{}' timed out after {} {}", new Object[]{executorName, 15, unit});
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Awaiting Shutdown of Executor '{}' was interrupted", (Object)executorName);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void await(CountDownLatch latch, String latchName) {
        try {
            int timeout = Environment.getOverallTimeout();
            TimeUnit unit = TimeUnit.MINUTES;
            if (!latch.await(timeout, unit)) {
                LOG.error("Awaiting Latch '{}' timed out after {} {}", new Object[]{latchName, timeout, unit});
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Awaiting Latch '{}' was interrupted", (Object)latchName);
            Thread.currentThread().interrupt();
        }
    }

    public static ImageWithDimension renderPage(Path document, int page) throws IOException {
        try (InputStream documentIS = Files.newInputStream(document, new OpenOption[0]);){
            ImageWithDimension imageWithDimension = Utilities.renderPage(documentIS, page);
            return imageWithDimension;
        }
    }

    public static ImageWithDimension renderPage(InputStream documentIS, int page) throws IOException {
        try (PDDocument pdDocument = PDDocument.load((InputStream)documentIS, (MemoryUsageSetting)Utilities.getMemorySettings(Environment.getDocumentCacheSize()));){
            if (page >= pdDocument.getNumberOfPages()) {
                throw new IllegalArgumentException("Page out of range. Last page is: " + pdDocument.getNumberOfPages());
            }
            pdDocument.setResourceCache((ResourceCache)new ResourceCacheWithLimitedImages());
            PDFRenderer pdfRenderer = new PDFRenderer(pdDocument);
            ImageWithDimension imageWithDimension = PdfComparator.renderPageAsImage(pdDocument, pdfRenderer, page);
            return imageWithDimension;
        }
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = name + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

