/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class Environment {
    private static Config config;

    private Environment() {
    }

    public static Path getTempDirectory() {
        if (config.hasPath("tempDir")) {
            return Paths.get(config.getString("tempDir"), new String[0]);
        }
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    public static int getNrOfImagesToCache() {
        return config.getInt("imageCacheSizeCount");
    }

    public static int getMergeCacheSize() {
        return Environment.getMB("mergeCacheSizeMB");
    }

    public static int getSwapCacheSize() {
        return Environment.getMB("swapCacheSizeMB");
    }

    public static int getDocumentCacheSize() {
        return Environment.getMB("documentCacheSizeMB") / 2;
    }

    public static int getMaxImageSize() {
        return config.getInt("maxImageSizeInCache");
    }

    public static int getOverallTimeout() {
        return config.getInt("overallTimeoutInMinutes");
    }

    private static int getMB(String path) {
        return config.getInt(path) * 1024 * 1024;
    }

    public static synchronized void reloadConfig() {
        ConfigFactory.invalidateCaches();
        config = Environment.loadConfig();
    }

    private static Config loadConfig() {
        return ConfigFactory.systemEnvironment().withFallback((ConfigMergeable)ConfigFactory.load());
    }

    public static boolean useParallelProcessing() {
        return config.getBoolean("parallelProcessing");
    }

    static {
        Environment.reloadConfig();
    }
}

