/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.javolution;

import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.SessionTranscoder;
import de.javakaffee.web.msm.TranscoderFactory;
import de.javakaffee.web.msm.serializer.javolution.CustomXMLFormat;
import de.javakaffee.web.msm.serializer.javolution.JavolutionTranscoder;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;

public class JavolutionTranscoderFactory
implements TranscoderFactory {
    private boolean _copyCollectionsForSerialization;
    private String[] _customConverterClassNames;
    private JavolutionTranscoder _transcoder;

    public SessionAttributesTranscoder createTranscoder(MemcachedSessionService.SessionManager manager) {
        return this.getTranscoder((Manager)manager);
    }

    private JavolutionTranscoder getTranscoder(Manager manager) {
        if (this._transcoder == null) {
            CustomXMLFormat<?>[] customFormats = this.loadCustomFormats(manager);
            this._transcoder = new JavolutionTranscoder(manager, this._copyCollectionsForSerialization, customFormats);
        }
        return this._transcoder;
    }

    public SessionTranscoder createSessionTranscoder(Manager manager) {
        return this.getTranscoder(manager);
    }

    private CustomXMLFormat<?>[] loadCustomFormats(Manager manager) {
        if (this._customConverterClassNames == null || this._customConverterClassNames.length == 0) {
            return null;
        }
        CustomXMLFormat[] customFormats = new CustomXMLFormat[this._customConverterClassNames.length];
        Loader loader = manager.getContainer().getLoader();
        for (int i = 0; i < this._customConverterClassNames.length; ++i) {
            String className = this._customConverterClassNames[i];
            try {
                CustomXMLFormat xmlFormat;
                customFormats[i] = xmlFormat = Class.forName(className, true, loader.getClassLoader()).asSubclass(CustomXMLFormat.class).newInstance();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load custom xml format " + className, e);
            }
        }
        return customFormats;
    }

    public void setCopyCollectionsForSerialization(boolean copyCollectionsForSerialization) {
        this._copyCollectionsForSerialization = copyCollectionsForSerialization;
    }

    public void setCustomConverterClassNames(String[] customConverterClassNames) {
        this._customConverterClassNames = customConverterClassNames;
    }
}

