/*
 * Decompiled with CFR 0.152.
 */
package de.grobmeier.jjson.convert;

import de.grobmeier.jjson.JSONArray;
import de.grobmeier.jjson.JSONBoolean;
import de.grobmeier.jjson.JSONNull;
import de.grobmeier.jjson.JSONNumber;
import de.grobmeier.jjson.JSONObject;
import de.grobmeier.jjson.JSONString;
import de.grobmeier.jjson.JSONValue;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class JSONDecoder {
    private static NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
    private JSONReader reader = null;
    private static final char CONTROL = '\\';

    public JSONDecoder(String json) {
        this.reader = new JSONReader(json);
    }

    private boolean isOpener(char c) {
        Opener[] opener;
        if (this.reader.readBefore() == '\\') {
            return false;
        }
        for (Opener item : opener = Opener.values()) {
            if (item.sign != c) continue;
            return true;
        }
        return false;
    }

    private boolean isCloser(char c) {
        Closer[] closer;
        if (this.reader.readBefore() == '\\') {
            return false;
        }
        for (Closer item : closer = Closer.values()) {
            if (item.sign != c) continue;
            return true;
        }
        return false;
    }

    public JSONValue decode() {
        char current = this.reader.current();
        if (current == Opener.OBJECT.sign) {
            return this.decodeObject();
        }
        if (current == Opener.STRING.sign) {
            return this.decodeString();
        }
        if (current == Opener.ARRAY.sign) {
            return this.decodeArray();
        }
        if (Character.isDigit(current) || current == Opener.MINUS.sign || current == Opener.PLUS.sign || current == Opener.DOT.sign) {
            return this.decodeNumber();
        }
        if (current == Opener.NULL.sign || current == Opener.NULL_UPPER.sign) {
            return this.decodeNull();
        }
        if (current == Opener.FALSE.sign || current == Opener.FALSE_UPPER.sign) {
            return this.decodeFalse();
        }
        if (current == Opener.TRUE.sign || current == Opener.TRUE_UPPER.sign) {
            return this.decodeTrue();
        }
        return null;
    }

    private JSONBoolean decodeTrue() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.reader.current());
        for (int i = 1; i < 4; ++i) {
            this.reader.next();
            char temp = this.reader.current();
            sb.append(temp);
        }
        if (!"TRUE".equalsIgnoreCase(sb.toString())) {
            System.err.print("JSON expected true value, was: " + sb.toString());
        }
        return new JSONBoolean(true);
    }

    private JSONBoolean decodeFalse() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.reader.current());
        for (int i = 1; i < 5; ++i) {
            this.reader.next();
            char temp = this.reader.current();
            sb.append(temp);
        }
        if (!"FALSE".equalsIgnoreCase(sb.toString())) {
            System.err.print("JSON expected true value, was: " + sb.toString());
        }
        return new JSONBoolean(false);
    }

    private JSONNull decodeNull() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.reader.current());
        for (int i = 1; i < 4; ++i) {
            this.reader.next();
            char temp = this.reader.current();
            sb.append(temp);
        }
        if (!"NULL".equalsIgnoreCase(sb.toString())) {
            System.err.print("JSON expected null value, was: " + sb.toString());
        }
        return new JSONNull();
    }

    private JSONNumber decodeNumber() {
        char temp;
        StringBuffer sb = new StringBuffer();
        if (this.reader.current() != Opener.PLUS.sign) {
            sb.append(this.reader.current());
        }
        while (this.reader.next() && !this.isCloser(temp = this.reader.current()) && temp != ',') {
            sb.append(temp);
        }
        this.reader.back();
        Number number = null;
        try {
            number = numberFormat.parse(sb.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new JSONNumber(number.toString());
    }

    private JSONObject decodeObject() {
        JSONObject result = new JSONObject();
        boolean hasNext = true;
        while (hasNext) {
            this.reader.next();
            if (this.reader.current() == Closer.jsonobject.sign) {
                hasNext = false;
                return result;
            }
            JSONString key = this.decodeString();
            while (this.reader.next()) {
                char temp = this.reader.current();
                if (temp != ':') continue;
                this.reader.next();
                break;
            }
            JSONValue value = this.decode();
            result.put(key.toString(), value);
            this.reader.next();
            if (this.reader.current() != Closer.jsonobject.sign) continue;
            hasNext = false;
        }
        return result;
    }

    private JSONArray decodeArray() {
        JSONArray result = new JSONArray();
        boolean hasNext = true;
        while (hasNext) {
            this.reader.next();
            if (this.reader.current() == Closer.jsonarray.sign) {
                hasNext = false;
                return result;
            }
            JSONValue value = this.decode();
            result.add(value);
            if (this.reader.current() == Closer.jsonarray.sign) {
                hasNext = false;
            }
            this.reader.next();
            if (this.reader.current() != Closer.jsonarray.sign) continue;
            hasNext = false;
        }
        return result;
    }

    private JSONString decodeString() {
        StringBuilder result = new StringBuilder();
        while (this.reader.current() == ' ') {
            this.reader.next();
        }
        if (this.reader.current() == Opener.STRING.sign) {
            while (this.reader.next()) {
                char temp = this.reader.current();
                if (Opener.STRING.sign != temp || '\\' == this.reader.readBefore()) {
                    result.append(temp);
                    continue;
                }
                break;
            }
        } else {
            return new JSONString("");
        }
        return new JSONString(result.toString());
    }

    private class JSONReader {
        private char[] json = null;
        private int index = 0;

        public JSONReader(String _json) {
            this.json = _json.trim().toCharArray();
        }

        public char read() {
            char result = ' ';
            if (this.json.length != 0) {
                result = this.json[this.index];
            }
            this.index = this.index + 1 < this.json.length ? ++this.index : 0;
            return result;
        }

        public char back() {
            this.index = this.index - 1 >= 0 ? --this.index : 0;
            return this.current();
        }

        public char current() {
            return this.json[this.index];
        }

        public boolean next() {
            if (this.index + 1 >= this.json.length) {
                return false;
            }
            ++this.index;
            return true;
        }

        public char readBefore() {
            if (this.index - 1 >= 0 && this.index < this.json.length) {
                return this.json[this.index - 1];
            }
            return ' ';
        }
    }

    static enum Closer {
        jsonobject('}'),
        jsonarray(']'),
        jsonstring('\"');

        private char sign = (char)32;

        private Closer(char s) {
            this.sign = s;
        }
    }

    static enum Opener {
        OBJECT('{'),
        ARRAY('['),
        STRING('\"'),
        PLUS('+'),
        MINUS('-'),
        DOT('.'),
        NULL('n'),
        NULL_UPPER('N'),
        TRUE('t'),
        TRUE_UPPER('T'),
        FALSE('f'),
        FALSE_UPPER('F');

        private char sign = (char)32;

        private Opener(char s) {
            this.sign = s;
        }
    }
}

