/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.utils;

import com.fasterxml.jackson.databind.JsonNode;
import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.Version;
import de.fraunhofer.iosb.ilt.frostclient.exception.NotAuthorizedException;
import de.fraunhofer.iosb.ilt.frostclient.exception.NotFoundException;
import de.fraunhofer.iosb.ilt.frostclient.exception.StatusCodeException;
import de.fraunhofer.iosb.ilt.frostclient.json.SimpleJsonMapper;
import de.fraunhofer.iosb.ilt.frostclient.models.CSDLModel;
import de.fraunhofer.iosb.ilt.frostclient.models.SensorThingsPlus;
import de.fraunhofer.iosb.ilt.frostclient.models.SensorThingsV11MultiDatastream;
import de.fraunhofer.iosb.ilt.frostclient.models.SensorThingsV11Projects;
import de.fraunhofer.iosb.ilt.frostclient.models.SensorThingsV11Sensing;
import de.fraunhofer.iosb.ilt.frostclient.models.SensorThingsV11Tasking;
import de.fraunhofer.iosb.ilt.frostclient.utils.ServerInfo;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Iterator;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final String NAME_NAME = "name";
    private static final String NAME_VALUE = "value";
    private static final String NAME_HEADER_ACCEPT = "Accept";
    private static final String NAME_HEADER_ODATA_VERSION = "OData-Version";
    private static final String NAME_CONFORMANCE = "conformance";
    private static final String NAME_SERVER_SETTINGS = "serverSettings";
    private static final String NAME_ENDPOINTS = "endpoints";

    public static void throwIfNotOk(HttpRequestBase request, CloseableHttpResponse response) throws StatusCodeException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 204) {
            throw new StatusCodeException(request.getURI().toString(), statusCode, response.getStatusLine().getReasonPhrase(), "");
        }
        if (statusCode < 200 || statusCode >= 300 || statusCode == 204) {
            String returnContent = null;
            try {
                returnContent = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            }
            catch (IOException exc) {
                LOGGER.warn("Failed to get content from error response.", (Throwable)exc);
            }
            if (statusCode == 401 || statusCode == 403) {
                request.getURI();
                throw new NotAuthorizedException(statusCode, request.getURI().toString(), response.getStatusLine().getReasonPhrase(), returnContent);
            }
            if (statusCode == 404) {
                throw new NotFoundException(request.getURI().toString(), response.getStatusLine().getReasonPhrase(), returnContent);
            }
            throw new StatusCodeException(request.getURI().toString(), statusCode, response.getStatusLine().getReasonPhrase(), returnContent);
        }
    }

    public static void createInsecureHttpClient(SensorThingsService service) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
        NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
        SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts);
        service.getClientBuilder().setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory);
        service.rebuildHttpClient();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ServerInfo detectServerInfo(SensorThingsService service) {
        HttpGet httpGet;
        ServerInfo serverInfo = service.getServerInfo();
        Utils.detectVersion(serverInfo);
        boolean modelsPreSet = !serverInfo.getModels().isEmpty();
        try {
            httpGet = new HttpGet(serverInfo.getBaseUrl().toURI());
            LOGGER.debug("Fetching: {}", (Object)httpGet.getURI());
            httpGet.addHeader(NAME_HEADER_ACCEPT, ContentType.APPLICATION_JSON.getMimeType());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Could not generate context url.", ex);
        }
        if (service.getBaseUrl().equals(SensorThingsService.NULL_URL_V11)) {
            return serverInfo;
        }
        try (CloseableHttpResponse response = service.execute((HttpRequestBase)httpGet);){
            HashSet<KnownModels> foundModels;
            block50: {
                Iterator it;
                block51: {
                    Iterator entries;
                    JsonNode serverSettings;
                    block49: {
                        JsonNode tree;
                        block48: {
                            Utils.throwIfNotOk((HttpRequestBase)httpGet, response);
                            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
                            tree = SimpleJsonMapper.getSimpleObjectMapper().readTree(json);
                            Header[] odataVersion = response.getHeaders(NAME_HEADER_ODATA_VERSION);
                            if (tree.has("@context") && odataVersion.length > 0) {
                                LOGGER.info("Detected OData 4.01.");
                                serverInfo.setVersion(Version.V_ODATA_4_01);
                                if (!modelsPreSet) {
                                    serverInfo.addModel(new CSDLModel());
                                }
                                Utils.findMqttEndpoint(tree.get(NAME_SERVER_SETTINGS), serverInfo);
                                ServerInfo serverInfo2 = serverInfo;
                                return serverInfo2;
                            }
                            foundModels = new HashSet<KnownModels>();
                            if (!tree.has(NAME_SERVER_SETTINGS)) break block48;
                            serverSettings = tree.get(NAME_SERVER_SETTINGS);
                            JsonNode conformance = serverSettings.get(NAME_CONFORMANCE);
                            entries = conformance.elements();
                            break block49;
                        }
                        if (!tree.has(NAME_VALUE)) break block50;
                        JsonNode entities = tree.get(NAME_VALUE);
                        it = entities.elements();
                        break block51;
                    }
                    block33: while (entries.hasNext()) {
                        String confClass = ((JsonNode)entries.next()).textValue();
                        if (confClass.startsWith("http://www.opengis.net/spec/iot_sensing/1.1/req/datamodel")) {
                            foundModels.add(KnownModels.STA_SENSING);
                            continue;
                        }
                        if (confClass.startsWith("http://www.opengis.net/spec/iot_sensing/1.1/req/multi-datastream")) {
                            foundModels.add(KnownModels.STA_MULTIDATASTREAM);
                            continue;
                        }
                        if (confClass.startsWith("http://www.opengis.net/spec/iot_sensing/1.1/req/actuator")) {
                            foundModels.add(KnownModels.STA_TASKING);
                            continue;
                        }
                        if (confClass.startsWith("http://www.opengis.net/spec/sensorthings-staplus/1.0/conf/core")) {
                            foundModels.add(KnownModels.STA_PLUS);
                            continue;
                        }
                        if (confClass.startsWith("https://fraunhoferiosb.github.io/FROST-Server/extensions/DataModel-Projects.html")) {
                            foundModels.add(KnownModels.PROJECTS);
                            continue;
                        }
                        switch (confClass) {
                            case "https://fraunhoferiosb.github.io/FROST-Server/extensions/MqttExpand.html": {
                                serverInfo.setMqttExpandAllowed(true);
                                break;
                            }
                            case "https://fraunhoferiosb.github.io/FROST-Server/extensions/MqttFilter.html": {
                                serverInfo.setMqttFilterAllowed(true);
                                continue block33;
                            }
                        }
                    }
                    Utils.findMqttEndpoint(serverSettings, serverInfo);
                    break block50;
                }
                block34: while (it.hasNext()) {
                    String entityName;
                    switch (entityName = ((JsonNode)it.next()).get(NAME_NAME).textValue()) {
                        case "Things": {
                            foundModels.add(KnownModels.STA_SENSING);
                            break;
                        }
                        case "MultiDatastreams": {
                            foundModels.add(KnownModels.STA_MULTIDATASTREAM);
                            break;
                        }
                        case "Tasks": {
                            foundModels.add(KnownModels.STA_TASKING);
                            break;
                        }
                        case "Parties": {
                            foundModels.add(KnownModels.STA_PLUS);
                            break;
                        }
                        case "Projects": {
                            foundModels.add(KnownModels.PROJECTS);
                            continue block34;
                        }
                    }
                }
            }
            if (modelsPreSet) return serverInfo;
            if (foundModels.contains((Object)KnownModels.STA_SENSING)) {
                LOGGER.info("Detected STA Sensing.");
                serverInfo.addModel(new SensorThingsV11Sensing());
            }
            if (foundModels.contains((Object)KnownModels.STA_MULTIDATASTREAM)) {
                LOGGER.info("Detected STA MultiDatastream.");
                serverInfo.addModel(new SensorThingsV11MultiDatastream());
            }
            if (foundModels.contains((Object)KnownModels.STA_TASKING)) {
                LOGGER.info("Detected STA Tasking.");
                serverInfo.addModel(new SensorThingsV11Tasking());
            }
            if (foundModels.contains((Object)KnownModels.STA_PLUS)) {
                LOGGER.info("Detected STAplus.");
                serverInfo.addModel(new SensorThingsPlus());
            }
            if (!foundModels.contains((Object)KnownModels.PROJECTS)) return serverInfo;
            LOGGER.info("Detected Projects.");
            serverInfo.addModel(new SensorThingsV11Projects());
            return serverInfo;
        }
        catch (IOException ex) {
            LOGGER.error("Failed to parse metadata", (Throwable)ex);
            return serverInfo;
        }
        catch (StatusCodeException ex) {
            LOGGER.warn("Failed to request metadata: HTTP status {} on URL {}", (Object)ex.getStatusCode(), (Object)httpGet.getURI());
        }
        return serverInfo;
    }

    private static void detectVersion(ServerInfo serverInfo) throws IllegalArgumentException {
        String url = StringUtils.removeEnd((String)serverInfo.getBaseUrl().toString(), (String)"/");
        String lastSegment = url.substring(url.lastIndexOf(47) + 1);
        Version detectedVersion = Version.findVersion(lastSegment);
        if (detectedVersion != null) {
            serverInfo.setVersion(detectedVersion);
        }
    }

    public static void findMqttEndpoint(JsonNode serverSettings, ServerInfo result) {
        if (serverSettings == null || result.isMqttUrlSet()) {
            return;
        }
        JsonNode mqttCreate = serverSettings.get("http://www.opengis.net/spec/iot_sensing/1.1/req/create-observations-via-mqtt/observations-creation");
        JsonNode mqttRead = serverSettings.get("http://www.opengis.net/spec/iot_sensing/1.1/req/receive-updates-via-mqtt/receive-updates");
        String bestEndpoint = Utils.findBestEndpoint(mqttCreate);
        if (StringHelper.isNullOrEmpty(bestEndpoint)) {
            bestEndpoint = Utils.findBestEndpoint(mqttRead);
        }
        LOGGER.info("MQTT Url used: {}", (Object)bestEndpoint);
        result.setMqttUrl(bestEndpoint);
    }

    private static String findBestEndpoint(JsonNode mqtt) {
        if (mqtt == null) {
            return null;
        }
        JsonNode endpoints = mqtt.get(NAME_ENDPOINTS);
        if (endpoints == null || !endpoints.isArray()) {
            return null;
        }
        String best = null;
        for (JsonNode endpoint : endpoints) {
            String url = endpoint.asText();
            LOGGER.info("MQTT Url detected: {}", (Object)url);
            if (best != null && !url.startsWith("ws")) continue;
            best = url;
        }
        return best;
    }

    public static <T> T instantiateClass(String className, Class<T> superClass) {
        Class<?> classToLoad;
        try {
            Class<?> clazz = Class.forName(className, false, superClass.getClassLoader());
            if (!superClass.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class " + className + " does not implement the interface AuthMethod");
            }
            classToLoad = clazz;
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Class '" + className + "' could not be found", ex);
        }
        try {
            return (T)classToLoad.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
            LOGGER.error("Class '{}' could not be instantiated", (Object)className, (Object)ex);
            return null;
        }
    }

    private static enum KnownModels {
        STA_SENSING,
        STA_MULTIDATASTREAM,
        STA_TASKING,
        STA_PLUS,
        PROJECTS;

    }
}

