/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.constraint.AllowedValues;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple.AbstractSimpleComponent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Count
extends AbstractSimpleComponent<Count, Number> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Count.class.getName());
    private Number value;
    private AllowedValues constraint;

    public AllowedValues getConstraint() {
        return this.constraint;
    }

    public void setConstraint(AllowedValues constraint) {
        this.constraint = constraint;
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    @Override
    public Count setValue(Number value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean valueIsValid() {
        return this.validate(this.value);
    }

    @Override
    public boolean validate(Object input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (input instanceof JsonNode) {
            JsonNode j = (JsonNode)input;
            return this.validate(j);
        }
        if (input instanceof Number) {
            Number n = (Number)input;
            return this.validate(n);
        }
        LOGGER.debug("Non-integral value {} for Count.", input);
        return false;
    }

    @Override
    public boolean validate(JsonNode input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (!input.isIntegralNumber()) {
            LOGGER.debug("Non-integral value {} for Count.", (Object)input);
            return false;
        }
        return this.validate(input.bigIntegerValue());
    }

    public boolean validate(Number input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if ((input instanceof Double || input instanceof Float || input instanceof BigDecimal) && input.doubleValue() != (double)input.longValue()) {
            LOGGER.debug("Non-integer value {} for Count!", (Object)input);
            return false;
        }
        if (this.constraint == null) {
            return true;
        }
        if (input instanceof BigInteger) {
            BigInteger bi = (BigInteger)input;
            return this.constraint.isValid(new BigDecimal(bi));
        }
        if (input instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)input;
            return this.constraint.isValid(bd);
        }
        return this.constraint.isValid(new BigDecimal(input.longValue()));
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode(this.value);
        hash = 79 * hash + Objects.hashCode(this.constraint);
        hash = 79 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Count other = (Count)obj;
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.constraint, other.constraint)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected Count self() {
        return this;
    }

    @Override
    public ObjectNode asJsonSchema() {
        ObjectNode schema = super.asJsonSchema().put("type", "integer");
        if (this.constraint != null) {
            this.constraint.addToSchema(schema);
        }
        return schema;
    }
}

