/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.complex;

import com.fasterxml.jackson.databind.JsonNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.AbstractDataComponent;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataArray
extends AbstractDataComponent<DataArray, List<Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DataArray.class.getName());
    private AbstractDataComponent elementType;
    private List<Object> values;

    public AbstractDataComponent getElementType() {
        return this.elementType;
    }

    public DataArray setElementType(AbstractDataComponent elementType) {
        this.elementType = elementType;
        return this.self();
    }

    @Override
    public List<Object> getValue() {
        return this.values;
    }

    @Override
    protected DataArray self() {
        return this;
    }

    @Override
    public DataArray setValue(List<Object> value) {
        this.values = value;
        return this.self();
    }

    @Override
    public boolean validate(Object input) {
        if (input instanceof List) {
            List list = (List)input;
            return this.validate(list);
        }
        if (input instanceof JsonNode) {
            JsonNode jn = (JsonNode)input;
            return this.validate(jn);
        }
        LOGGER.error("Input is not a List or JsonArray");
        return false;
    }

    public boolean validate(List input) {
        if (this.elementType == null) {
            LOGGER.error("ElementType is not set.");
            return false;
        }
        for (Object item : input) {
            if (this.elementType.validate(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(JsonNode input) {
        if (input.isArray()) {
            Iterator it = input.values();
            while (it.hasNext()) {
                JsonNode item = (JsonNode)it.next();
                if (this.elementType.validate(item)) continue;
                return false;
            }
            return true;
        }
        LOGGER.error("Input is not a JsonArray");
        return false;
    }

    @Override
    public boolean valueIsValid() {
        return this.validate(this.values);
    }
}

