/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.ext;

import de.fraunhofer.iosb.ilt.frostclient.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeObject;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Objects;
import net.time4j.Moment;
import net.time4j.engine.Temporal;
import net.time4j.range.MomentInterval;

public class TimeInterval
implements TimeObject,
ComplexValue<TimeInterval> {
    public static EntityPropertyMain<TimeInstant> EP_START_TIME = TypeComplex.EP_START_TIME;
    public static EntityPropertyMain<TimeInstant> EP_END_TIME = TypeComplex.EP_END_TIME;
    private MomentInterval interval;

    public TimeInterval() {
        this.interval = null;
    }

    public TimeInterval(MomentInterval interval) {
        this.interval = interval;
    }

    public int hashCode() {
        return Objects.hash(this.interval);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInterval other = (TimeInterval)obj;
        return Objects.equals(this.interval, other.interval);
    }

    public static TimeInterval create(Moment start, Moment end) {
        return new TimeInterval(MomentInterval.between((Moment)start, (Moment)end));
    }

    public static TimeInterval create(Instant start, Instant end) {
        return new TimeInterval(MomentInterval.between((Instant)start, (Instant)end));
    }

    public static TimeInterval create(ZonedDateTime start, ZonedDateTime end) {
        return new TimeInterval(MomentInterval.between((Instant)start.toInstant(), (Instant)end.toInstant()));
    }

    public static TimeInterval parse(String value) {
        try {
            return new TimeInterval(MomentInterval.parseISO((String)value));
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Failed to parse TimeInterval " + StringHelper.cleanForLogging(value), ex);
        }
    }

    public MomentInterval getInterval() {
        return this.interval;
    }

    @Override
    public boolean isEmpty() {
        return this.interval == null;
    }

    @Override
    public String asISO8601() {
        return StringHelper.FORMAT_INTERVAL.print((Object)this.interval);
    }

    public String toString() {
        return this.asISO8601();
    }

    @Override
    public <P> P getProperty(Property<P> property) {
        if (this.interval == null) {
            return null;
        }
        if (property == EP_START_TIME) {
            return (P)this.interval.getStartAsMoment();
        }
        if (property == EP_END_TIME) {
            return (P)this.interval.getEndAsMoment();
        }
        throw new IllegalArgumentException("Unknown sub-property: " + String.valueOf(property));
    }

    @Override
    public TimeInterval setProperty(Property property, Object value) {
        Moment moment;
        if (value == null) {
            return this;
        }
        if (value instanceof Moment) {
            Moment m;
            moment = m = (Moment)value;
        } else if (value instanceof Instant) {
            Instant i = (Instant)value;
            moment = Moment.from((Instant)i);
        } else if (value instanceof TimeInstant) {
            TimeInstant ti = (TimeInstant)value;
            moment = ti.getDateTime();
        } else {
            throw new IllegalArgumentException("TimeInterval only accepts Moment, Instant or TimeInstant, not " + value.getClass().getName());
        }
        if (property == EP_START_TIME) {
            this.interval = this.interval == null ? MomentInterval.since((Moment)moment) : (MomentInterval)this.interval.withStart((Temporal)moment);
            return this;
        }
        if (property == EP_END_TIME) {
            this.interval = this.interval == null ? (MomentInterval)MomentInterval.until((Moment)moment).withOpenEnd() : (MomentInterval)((MomentInterval)this.interval.withEnd((Temporal)moment)).withOpenEnd();
            return this;
        }
        throw new IllegalArgumentException("Unknown sub-property: " + String.valueOf(property));
    }

    public Moment getStart() {
        if (this.interval == null) {
            return null;
        }
        return this.interval.getStartAsMoment();
    }

    public Moment getEnd() {
        if (this.interval == null) {
            return null;
        }
        return this.interval.getEndAsMoment();
    }

    @Override
    public Object getProperty(String name) {
        throw new IllegalArgumentException("Can not get custom properties from TimeInterval");
    }

    @Override
    public TimeInterval setProperty(String name, Object value) {
        throw new IllegalArgumentException("Can not set custom properties on TimeInterval");
    }
}

