/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.property;

import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.PropertyType;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public abstract class PropertyAbstract<P>
implements Property<P> {
    private String name;
    private PropertyType type;
    protected boolean readOnly;
    protected boolean keyPart;
    protected boolean nullable;
    protected List<Annotation> annotations = new ArrayList<Annotation>();

    public PropertyAbstract(String name, PropertyType type, boolean readOnly) {
        this(name, type, readOnly, true);
    }

    public PropertyAbstract(String name, PropertyType type, boolean readOnly, boolean nullable) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        this.name = name;
        this.type = type;
        this.readOnly = readOnly;
        this.nullable = nullable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public String getJsonName() {
        return this.getName();
    }

    @Override
    public PropertyType getType() {
        return this.type;
    }

    protected void setType(PropertyType type) {
        this.type = type;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isKeyPart() {
        return this.keyPart;
    }

    public void setKeyPart(boolean keyPart) {
        this.keyPart = keyPart;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public PropertyAbstract<P> setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public PropertyAbstract<P> addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }
}

