/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model;

import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.PropertyType;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypePrimitive;
import de.fraunhofer.iosb.ilt.frostclient.models.DataModel;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ModelRegistry.class.getName());
    public static final EntityPropertyMain<String> EP_SELFLINK = new EntityPropertyMain("@iot.selfLink", TypePrimitive.EDM_STRING).setAliases("selfLink");
    private final Map<String, EntityType> entityTypesByName = new TreeMap<String, EntityType>();
    private final Map<String, EntityType> containersByName = new TreeMap<String, EntityType>();
    private final Set<EntityType> entityTypes = new LinkedHashSet<EntityType>();
    private final Map<String, PropertyType> propertyTypes = new TreeMap<String, PropertyType>();
    private Map<Class<? extends DataModel>, DataModel> dataModels = new HashMap<Class<? extends DataModel>, DataModel>();
    private boolean initialised;

    public final ModelRegistry registerEntityType(EntityType type) {
        EntityType existing = this.entityTypesByName.get(type.entityName);
        if (existing == type) {
            LOGGER.info("Entity type {} already registered.", (Object)type.entityName);
            return this;
        }
        if (existing != null) {
            LOGGER.error("Duplicate entity type name: {}", (Object)type.entityName);
            throw new IllegalArgumentException("An entity type named " + type.entityName + " is already registered");
        }
        this.entityTypesByName.put(type.entityName, type);
        this.entityTypes.add(type);
        type.setModelRegistry(this);
        return this;
    }

    public final ModelRegistry registerEntityContainer(String name, EntityType type) {
        this.containersByName.put(name, type);
        return this;
    }

    public final EntityType getEntityTypeForName(String typeName) {
        EntityType type = this.entityTypesByName.get(typeName);
        return type;
    }

    public final Set<EntityType> getEntityTypes() {
        return this.entityTypes;
    }

    public Map<String, EntityType> getContainers() {
        return this.containersByName;
    }

    public EntityType getEntityTypeForContainer(String name) {
        return this.containersByName.get(name);
    }

    public ModelRegistry registerPropertyType(PropertyType type) {
        this.propertyTypes.put(type.getName(), type);
        return this;
    }

    public final PropertyType getPropertyType(String name) {
        PropertyType type = this.propertyTypes.get(name);
        if (type != null) {
            return type;
        }
        type = TypePrimitive.getType(name);
        if (type != null) {
            return type;
        }
        type = TypeComplex.getType(name);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("unknown property type: " + name);
    }

    public Map<String, PropertyType> getPropertyTypes() {
        return this.propertyTypes;
    }

    public <T extends DataModel> T getModel(Class<T> clazz) {
        return (T)this.dataModels.get(clazz);
    }

    public <T extends DataModel> boolean hasModel(Class<T> clazz) {
        return this.dataModels.containsKey(clazz);
    }

    public ModelRegistry addDataModel(DataModel model) {
        this.dataModels.put(model.getClass(), model);
        return this;
    }

    public synchronized ModelRegistry initFinalise() {
        if (this.initialised) {
            return this;
        }
        LOGGER.info("Finalising {} EntityTypes.", (Object)this.entityTypes.size());
        for (EntityType type : this.entityTypes) {
            type.init();
            if (StringHelper.isNullOrEmpty(type.mainSet)) continue;
            this.containersByName.put(type.mainSet, type);
        }
        this.initialised = true;
        return this;
    }

    public boolean isInitialised() {
        return this.initialised;
    }
}

