/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.exception.StatusCodeException;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.JsonReader;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.query.Expand;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import de.fraunhofer.iosb.ilt.frostclient.utils.Utils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySet
implements Iterable<Entity> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EntitySet.class.getName());
    protected List<Entity> data = new ArrayList<Entity>();
    protected boolean dataIsInitial = true;
    protected long count = -1L;
    protected String initialLink;
    protected String nextLink;
    protected Expand.ExpandItem expandItem;
    @JsonIgnore
    private final EntityType type;
    @JsonIgnore
    private final Entity parent;
    @JsonIgnore
    private final NavigationPropertyEntitySet navigationProperty;
    @JsonIgnore
    private SensorThingsService service;

    public EntitySet(EntityType type) {
        this.type = type;
        this.parent = null;
        this.navigationProperty = null;
    }

    public EntitySet(Entity parent, NavigationPropertyEntitySet navigationProperty) {
        this.type = navigationProperty.getEntityType();
        this.parent = parent;
        this.navigationProperty = navigationProperty;
    }

    public Expand.ExpandItem getExpandItem() {
        return this.expandItem;
    }

    public EntitySet setExpandItem(Expand.ExpandItem expandItem) {
        this.expandItem = expandItem;
        if (expandItem == null) {
            return this;
        }
        this.generateInitialLink();
        Expand expand = expandItem.getExpand();
        if (expand != null) {
            for (Entity entity : this.data) {
                entity.setExpand(expand);
            }
        }
        return this;
    }

    public List<Entity> toList() {
        return this.data;
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator<Entity> iterator() {
        return new IteratorImpl(this);
    }

    public EntitySet reset() {
        this.nextLink = this.initialLink;
        this.data = new ArrayList<Entity>();
        return this;
    }

    public EntitySet setInitialLink(String link) {
        this.initialLink = link;
        return this;
    }

    private void generateInitialLink() {
        if (this.service == null) {
            return;
        }
        this.initialLink = this.parent != null && this.navigationProperty != null ? this.service.getFullPathString(this.parent, this.navigationProperty) : this.service.getFullPathString(this.type);
        if (this.expandItem == null) {
            return;
        }
        String queryParams = this.expandItem.toUrlAsQuery();
        if (!StringHelper.isNullOrEmpty(queryParams)) {
            this.initialLink = this.initialLink + "?" + queryParams;
        }
    }

    public EntitySet fetchNext() {
        this.dataIsInitial = false;
        if (this.nextLink == null) {
            this.data = Collections.emptyList();
            return this;
        }
        HttpGet httpGet = new HttpGet(this.nextLink);
        httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        LOGGER.debug("Fetching: {}", (Object)httpGet.getURI());
        try (CloseableHttpResponse response = this.service.execute((HttpRequestBase)httpGet);){
            Utils.throwIfNotOk((HttpRequestBase)httpGet, response);
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            JsonReader reader = new JsonReader(this.service.getModelRegistry());
            EntitySet nextSet = reader.parseEntitySet(this.type, json).setService(this.service).setExpandItem(this.expandItem);
            this.data = nextSet.toList();
            this.nextLink = nextSet.getNextLink();
        }
        catch (IOException | ParseException exc) {
            LOGGER.error("Failed deserializing collection.", exc);
            this.nextLink = null;
            this.data = new ArrayList<Entity>();
        }
        catch (StatusCodeException exc) {
            LOGGER.error("Failed follow nextlink: {} - '{}' - {}", new Object[]{exc.getStatusCode(), this.nextLink, StringHelper.cleanForLogging(exc.getReturnedContent(), 100)});
            LOGGER.debug("Response: {}", (Object)exc.getReturnedContent());
            this.nextLink = null;
            this.data = new ArrayList<Entity>();
        }
        return this;
    }

    public void add(Entity e) {
        this.data.add(e);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.navigationProperty);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntitySet other = (EntitySet)obj;
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        return Objects.equals(this.navigationProperty, other.navigationProperty);
    }

    public long getCount() {
        return this.count;
    }

    public EntitySet setCount(long count) {
        this.count = count;
        return this;
    }

    public boolean hasNextLink() {
        return !StringHelper.isNullOrEmpty(this.nextLink);
    }

    public String getNextLink() {
        return this.nextLink;
    }

    public EntitySet setNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public EntityType getEntityType() {
        return this.type;
    }

    public NavigationPropertyEntitySet getNavigationProperty() {
        return this.navigationProperty;
    }

    public SensorThingsService getService() {
        this.generateInitialLink();
        return this.service;
    }

    public EntitySet setService(SensorThingsService service) {
        this.service = service;
        for (Entity entity : this.data) {
            entity.setService(service);
        }
        return this;
    }

    private static class IteratorImpl
    implements Iterator<Entity> {
        private final EntitySet parent;
        private List<Entity> data;
        private Iterator<Entity> currentIterator;
        private String nextLink;

        public IteratorImpl(EntitySet parent) {
            this.parent = parent;
            if (parent.dataIsInitial) {
                this.data = parent.data;
                this.nextLink = parent.getNextLink();
            } else {
                this.data = new ArrayList<Entity>();
                this.nextLink = parent.initialLink;
            }
            this.currentIterator = this.data.iterator();
        }

        private void fetchNextList() {
            if (this.nextLink == null) {
                this.currentIterator = null;
                return;
            }
            this.fetchNext();
            this.currentIterator = this.data.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator == null) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            this.fetchNextList();
            return this.hasNext();
        }

        @Override
        public Entity next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIterator.next();
        }

        public void fetchNext() {
            if (this.nextLink == null) {
                this.data = Collections.emptyList();
                return;
            }
            HttpGet httpGet = new HttpGet(this.nextLink);
            httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            LOGGER.debug("Fetching: {}", (Object)httpGet.getURI());
            try (CloseableHttpResponse response = this.parent.service.execute((HttpRequestBase)httpGet);){
                Utils.throwIfNotOk((HttpRequestBase)httpGet, response);
                String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
                JsonReader reader = new JsonReader(this.parent.service.getModelRegistry());
                EntitySet nextSet = reader.parseEntitySet(this.parent.type, json).setService(this.parent.service).setExpandItem(this.parent.expandItem);
                this.data = nextSet.toList();
                this.nextLink = nextSet.getNextLink();
            }
            catch (IOException | ParseException exc) {
                LOGGER.error("Failed deserializing collection.", exc);
                this.nextLink = null;
                this.data = new ArrayList<Entity>();
            }
            catch (StatusCodeException exc) {
                LOGGER.error("Failed follow nextlink: {} - '{}' - {}", new Object[]{exc.getStatusCode(), this.nextLink, StringHelper.cleanForLogging(exc.getReturnedContent(), 100)});
                LOGGER.debug("Response: {}", (Object)exc.getReturnedContent());
                this.nextLink = null;
                this.data = new ArrayList<Entity>();
            }
        }
    }
}

