/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import de.fraunhofer.iosb.ilt.frostclient.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ComplexValueImpl
implements ComplexValue<ComplexValueImpl> {
    public static final TypeReference<ComplexValueImpl> TYPE_REFERENCE = new TypeReference<ComplexValueImpl>(){};
    private final TypeComplex type;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public ComplexValueImpl(TypeComplex type) {
        this.type = type;
    }

    @JsonIgnore
    public TypeComplex getType() {
        return this.type;
    }

    @Override
    public <P> P getProperty(Property<P> property) {
        return (P)this.properties.get(property.getJsonName());
    }

    @Override
    public <P> ComplexValueImpl setProperty(Property<P> property, P value) {
        this.properties.put(property.getJsonName(), value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAllProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @JsonAnySetter
    public void setAnyProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public ComplexValueImpl setProperty(String name, Object value) {
        if (!this.type.isOpenType()) {
            throw new IllegalArgumentException("Can not set custom properties on non-openType " + String.valueOf(this.type));
        }
        this.properties.put(name, value);
        return this;
    }

    public static TypeComplex.Instantiator createFor(TypeComplex type) {
        return () -> new ComplexValueImpl(type);
    }
}

