/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.auth;

import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorBoolean;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorPassword;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.auth.AuthMethod;
import de.fraunhofer.iosb.ilt.frostclient.auth.AuthSettings;
import de.fraunhofer.iosb.ilt.frostclient.utils.ServerInfo;
import de.fraunhofer.iosb.ilt.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.settings.annotation.DefaultValueBoolean;
import de.fraunhofer.iosb.ilt.settings.annotation.SensitiveValue;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthBasic
implements AnnotatedConfigurable<Void, Void>,
AuthMethod,
ConfigDefaults {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthBasic.class);
    @DefaultValue(value="")
    public static final String NAME_VAR_USERNAME = "username";
    @DefaultValue(value="")
    @SensitiveValue
    public static final String NAME_VAR_PASSWORD = "password";
    @DefaultValueBoolean(value=false)
    public static final String NAME_VAR_IGNORE_SSL_ERRORS = "ignoreSslErrors";
    @ConfigurableField(editor=EditorString.class, label="Username", description="The username to use for authentication")
    @EditorString.EdOptsString
    private String username;
    @ConfigurableField(editor=EditorPassword.class, label="Password", description="The password to use for authentication")
    @EditorPassword.EdOptsPassword
    private String password;
    @ConfigurableField(editor=EditorBoolean.class, label="IgnoreSslErrors", description="Ignore SSL certificate errors. This is a bad idea unless you know what you are doing.")
    @EditorBoolean.EdOptsBool
    private boolean ignoreSslErrors;

    @Override
    public void setAuth(SensorThingsService service) {
        AuthSettings authSettings = service.getSettings().getAuthSettings();
        if (this.username == null) {
            this.username = authSettings.getSettings().get(NAME_VAR_USERNAME, this.getClass());
            this.password = authSettings.getSettings().get(NAME_VAR_PASSWORD, this.getClass());
            this.ignoreSslErrors = authSettings.getSettings().getBoolean(NAME_VAR_IGNORE_SSL_ERRORS, this.getClass());
        }
        try {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            ServerInfo serverInfo = service.getServerInfo();
            service.getOrCreateMqttConfig().setAuth(this.username, this.password);
            URL url = serverInfo.getBaseUrl();
            credsProvider.setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            HttpClientBuilder clientBuilder = service.getClientBuilder().setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            if (this.ignoreSslErrors) {
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(new SSLContextBuilder().loadTrustMaterial((chain, authType) -> true).build());
                clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            }
            service.rebuildHttpClient();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
            LOGGER.error("Failed to initialise basic auth.", (Throwable)ex);
        }
    }
}

