package de.flapdoodle.reverse.transitions;

import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Join}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJoin.builder()}.
 */
@Generated(from = "Join", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableJoin<L, R, D> extends Join<L, R, D> {
  private final StateID<L> left;
  private final StateID<R> right;
  private final StateID<D> destination;
  private final BiFunction<L, R, State<D>> action;
  private final String transitionLabel;

  private ImmutableJoin(ImmutableJoin.Builder<L, R, D> builder) {
    this.left = builder.left;
    this.right = builder.right;
    this.destination = builder.destination;
    this.action = builder.action;
    this.transitionLabel = builder.transitionLabel != null
        ? builder.transitionLabel
        : Objects.requireNonNull(super.transitionLabel(), "transitionLabel");
  }

  private ImmutableJoin(
      StateID<L> left,
      StateID<R> right,
      StateID<D> destination,
      BiFunction<L, R, State<D>> action,
      String transitionLabel) {
    this.left = left;
    this.right = right;
    this.destination = destination;
    this.action = action;
    this.transitionLabel = transitionLabel;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public StateID<L> left() {
    return left;
  }

  /**
   * @return The value of the {@code right} attribute
   */
  @Override
  public StateID<R> right() {
    return right;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public StateID<D> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @Override
  protected BiFunction<L, R, State<D>> action() {
    return action;
  }

  /**
   * @return The value of the {@code transitionLabel} attribute
   */
  @Override
  public String transitionLabel() {
    return transitionLabel;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Join#left() left} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJoin<L, R, D> withLeft(StateID<L> value) {
    if (this.left == value) return this;
    StateID<L> newValue = Objects.requireNonNull(value, "left");
    return new ImmutableJoin<>(newValue, this.right, this.destination, this.action, this.transitionLabel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Join#right() right} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for right
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJoin<L, R, D> withRight(StateID<R> value) {
    if (this.right == value) return this;
    StateID<R> newValue = Objects.requireNonNull(value, "right");
    return new ImmutableJoin<>(this.left, newValue, this.destination, this.action, this.transitionLabel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Join#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJoin<L, R, D> withDestination(StateID<D> value) {
    if (this.destination == value) return this;
    StateID<D> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableJoin<>(this.left, this.right, newValue, this.action, this.transitionLabel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Join#action() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJoin<L, R, D> withAction(BiFunction<L, R, State<D>> value) {
    if (this.action == value) return this;
    BiFunction<L, R, State<D>> newValue = Objects.requireNonNull(value, "action");
    return new ImmutableJoin<>(this.left, this.right, this.destination, newValue, this.transitionLabel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Join#transitionLabel() transitionLabel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transitionLabel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJoin<L, R, D> withTransitionLabel(String value) {
    String newValue = Objects.requireNonNull(value, "transitionLabel");
    if (this.transitionLabel.equals(newValue)) return this;
    return new ImmutableJoin<>(this.left, this.right, this.destination, this.action, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJoin} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJoin<?, ?, ?>
        && equalTo(0, (ImmutableJoin<?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableJoin<?, ?, ?> another) {
    return left.equals(another.left)
        && right.equals(another.right)
        && destination.equals(another.destination)
        && action.equals(another.action)
        && transitionLabel.equals(another.transitionLabel);
  }

  /**
   * Computes a hash code from attributes: {@code left}, {@code right}, {@code destination}, {@code action}, {@code transitionLabel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + left.hashCode();
    h += (h << 5) + right.hashCode();
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + action.hashCode();
    h += (h << 5) + transitionLabel.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Join} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Join{"
        + "left=" + left
        + ", right=" + right
        + ", destination=" + destination
        + ", action=" + action
        + ", transitionLabel=" + transitionLabel
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long SOURCES_LAZY_INIT_BIT = 0x1L;

  private transient Set<StateID<?>> sources;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Join#sources() sources} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code sources} attribute
   */
  @Override
  public Set<StateID<?>> sources() {
    if ((lazyInitBitmap & SOURCES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SOURCES_LAZY_INIT_BIT) == 0) {
          this.sources = Objects.requireNonNull(super.sources(), "sources");
          lazyInitBitmap |= SOURCES_LAZY_INIT_BIT;
        }
      }
    }
    return sources;
  }

  /**
   * Creates an immutable copy of a {@link Join} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable Join instance
   */
  public static <L, R, D> ImmutableJoin<L, R, D> copyOf(Join<L, R, D> instance) {
    if (instance instanceof ImmutableJoin<?, ?, ?>) {
      return (ImmutableJoin<L, R, D>) instance;
    }
    return ImmutableJoin.<L, R, D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJoin ImmutableJoin}.
   * <pre>
   * ImmutableJoin.&amp;lt;L, R, D&amp;gt;builder()
   *    .left(de.flapdoodle.reverse.StateID&amp;lt;L&amp;gt;) // required {@link Join#left() left}
   *    .right(de.flapdoodle.reverse.StateID&amp;lt;R&amp;gt;) // required {@link Join#right() right}
   *    .destination(de.flapdoodle.reverse.StateID&amp;lt;D&amp;gt;) // required {@link Join#destination() destination}
   *    .action(function.BiFunction&amp;lt;L, R, de.flapdoodle.reverse.State&amp;lt;D&amp;gt;&amp;gt;) // required {@link Join#action() action}
   *    .transitionLabel(String) // optional {@link Join#transitionLabel() transitionLabel}
   *    .build();
   * </pre>
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @param <D> generic parameter D
   * @return A new ImmutableJoin builder
   */
  public static <L, R, D> ImmutableJoin.Builder<L, R, D> builder() {
    return new ImmutableJoin.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableJoin ImmutableJoin}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Join", generator = "Immutables")
  public static final class Builder<L, R, D> {
    private static final long INIT_BIT_LEFT = 0x1L;
    private static final long INIT_BIT_RIGHT = 0x2L;
    private static final long INIT_BIT_DESTINATION = 0x4L;
    private static final long INIT_BIT_ACTION = 0x8L;
    private long initBits = 0xfL;

    private StateID<L> left;
    private StateID<R> right;
    private StateID<D> destination;
    private BiFunction<L, R, State<D>> action;
    private String transitionLabel;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.reverse.transitions.Join} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> from(Join<L, R, D> instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.reverse.naming.HasLabel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> from(HasLabel instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof Join<?, ?, ?>) {
        Join<L, R, D> instance = (Join<L, R, D>) object;
        destination(instance.destination());
        action(instance.action());
        right(instance.right());
        left(instance.left());
        if ((bits & 0x1L) == 0) {
          transitionLabel(instance.transitionLabel());
          bits |= 0x1L;
        }
      }
      if (object instanceof HasLabel) {
        HasLabel instance = (HasLabel) object;
        if ((bits & 0x1L) == 0) {
          transitionLabel(instance.transitionLabel());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Join#left() left} attribute.
     * @param left The value for left 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> left(StateID<L> left) {
      this.left = Objects.requireNonNull(left, "left");
      initBits &= ~INIT_BIT_LEFT;
      return this;
    }

    /**
     * Initializes the value for the {@link Join#right() right} attribute.
     * @param right The value for right 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> right(StateID<R> right) {
      this.right = Objects.requireNonNull(right, "right");
      initBits &= ~INIT_BIT_RIGHT;
      return this;
    }

    /**
     * Initializes the value for the {@link Join#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> destination(StateID<D> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Join#action() action} attribute.
     * @param action The value for action 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> action(BiFunction<L, R, State<D>> action) {
      this.action = Objects.requireNonNull(action, "action");
      initBits &= ~INIT_BIT_ACTION;
      return this;
    }

    /**
     * Initializes the value for the {@link Join#transitionLabel() transitionLabel} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Join#transitionLabel() transitionLabel}.</em>
     * @param transitionLabel The value for transitionLabel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> transitionLabel(String transitionLabel) {
      this.transitionLabel = Objects.requireNonNull(transitionLabel, "transitionLabel");
      return this;
    }

    /**
     * Builds a new {@link ImmutableJoin ImmutableJoin}.
     * @return An immutable instance of Join
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJoin<L, R, D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJoin<L, R, D>(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LEFT) != 0) attributes.add("left");
      if ((initBits & INIT_BIT_RIGHT) != 0) attributes.add("right");
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_ACTION) != 0) attributes.add("action");
      return "Cannot build Join, some of required attributes are not set " + attributes;
    }
  }
}
