/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse.graph;

import de.flapdoodle.reverse.graph.StateVertex;
import de.flapdoodle.reverse.graph.TransitionVertex;
import de.flapdoodle.types.Either;
import java.util.LinkedHashMap;
import java.util.function.Function;

public abstract class Vertex {
    public static Function<Vertex, String> asId() {
        LinkedHashMap typeCounter = new LinkedHashMap();
        LinkedHashMap transitionMap = new LinkedHashMap();
        return vertex -> (String)Vertex.asEither(vertex).mapLeft(StateVertex::stateId).mapLeft(type -> (type.name().isEmpty() ? "<empty>" : type.name()) + ":" + type.type().toString()).mapRight(TransitionVertex::transition).mapRight(transition -> {
            Integer number = (Integer)transitionMap.get(transition);
            if (number == null) {
                typeCounter.putIfAbsent(transition.getClass(), -1);
                number = (Integer)typeCounter.get(transition.getClass()) + 1;
                typeCounter.put(transition.getClass(), number);
                transitionMap.put(transition, number);
            }
            return transition.getClass().getName() + ":" + number;
        }).map(Function.identity(), Function.identity());
    }

    public static Either<StateVertex, TransitionVertex> asEither(Vertex vertex) {
        if (vertex instanceof StateVertex) {
            return Either.left((Object)((StateVertex)vertex));
        }
        if (vertex instanceof TransitionVertex) {
            return Either.right((Object)((TransitionVertex)vertex));
        }
        throw new IllegalArgumentException("unknown vertex type: " + vertex + "(" + vertex.getClass() + ")");
    }
}

