/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import de.flapdoodle.types.ImmutableLeft;
import de.flapdoodle.types.ImmutableRight;
import de.flapdoodle.types.Nullable;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.immutables.value.Value;

public abstract class Either<L, R> {
    public abstract boolean isLeft();

    @Nullable
    public abstract L left();

    @Nullable
    public abstract R right();

    public <T> Either<T, R> mapLeft(Function<L, T> transformation) {
        return this.isLeft() ? Either.left(transformation.apply(this.left())) : this;
    }

    public <T> Either<L, T> mapRight(Function<R, T> transformation) {
        return this.isLeft() ? this : Either.right(transformation.apply(this.right()));
    }

    public <T> T map(Function<L, T> leftTransformation, Function<R, T> rightTransformation) {
        Either<T, T> mapped = this.mapLeft(leftTransformation).mapRight(rightTransformation);
        return mapped.isLeft() ? mapped.left() : mapped.right();
    }

    public static <L, R> Either<L, R> left(L left) {
        return ImmutableLeft.of(left);
    }

    public static <L, R> Either<L, R> right(R right) {
        return ImmutableRight.of(right);
    }

    @Value.Immutable
    static abstract class Right<L, R>
    extends Either<L, R> {
        Right() {
        }

        @Override
        @Nullable
        @Value.Parameter
        public abstract R right();

        @Override
        @Value.Auxiliary
        public L left() {
            throw new NoSuchElementException("is right");
        }

        @Override
        public boolean isLeft() {
            return false;
        }
    }

    @Value.Immutable
    static abstract class Left<L, R>
    extends Either<L, R> {
        Left() {
        }

        @Override
        @Nullable
        @Value.Parameter
        public abstract L left();

        @Override
        @Value.Auxiliary
        public R right() {
            throw new NoSuchElementException("is left");
        }

        @Override
        public boolean isLeft() {
            return true;
        }
    }
}

