/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reflection;

import de.flapdoodle.reflection.MapTypeInfo;
import de.flapdoodle.reflection.TypeInfo;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="MapTypeInfo", generator="Immutables")
public final class ImmutableMapTypeInfo<K, V>
extends MapTypeInfo<K, V> {
    private final TypeInfo<K> key;
    private final TypeInfo<V> value;

    private ImmutableMapTypeInfo(TypeInfo<K> key, TypeInfo<V> value) {
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
    }

    private ImmutableMapTypeInfo(ImmutableMapTypeInfo<K, V> original, TypeInfo<K> key, TypeInfo<V> value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public TypeInfo<K> key() {
        return this.key;
    }

    @Override
    public TypeInfo<V> value() {
        return this.value;
    }

    public final ImmutableMapTypeInfo<K, V> withKey(TypeInfo<K> value) {
        if (this.key == value) {
            return this;
        }
        TypeInfo<K> newValue = Objects.requireNonNull(value, "key");
        return new ImmutableMapTypeInfo<K, V>(this, newValue, this.value);
    }

    public final ImmutableMapTypeInfo<K, V> withValue(TypeInfo<V> value) {
        if (this.value == value) {
            return this;
        }
        TypeInfo<V> newValue = Objects.requireNonNull(value, "value");
        return new ImmutableMapTypeInfo<K, V>(this, this.key, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMapTypeInfo && this.equalTo(0, (ImmutableMapTypeInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableMapTypeInfo<?, ?> another) {
        return this.key.equals(another.key) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "MapTypeInfo{key=" + this.key + ", value=" + this.value + "}";
    }

    public static <K, V> ImmutableMapTypeInfo<K, V> of(TypeInfo<K> key, TypeInfo<V> value) {
        return new ImmutableMapTypeInfo<K, V>(key, value);
    }

    public static <K, V> ImmutableMapTypeInfo<K, V> copyOf(MapTypeInfo<K, V> instance) {
        if (instance instanceof ImmutableMapTypeInfo) {
            return (ImmutableMapTypeInfo)instance;
        }
        return ImmutableMapTypeInfo.builder().from(instance).build();
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    @Generated(from="MapTypeInfo", generator="Immutables")
    public static final class Builder<K, V> {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        private TypeInfo<K> key;
        private TypeInfo<V> value;

        private Builder() {
        }

        public final Builder<K, V> from(MapTypeInfo<K, V> instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            this.value(instance.value());
            return this;
        }

        public final Builder<K, V> key(TypeInfo<K> key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<K, V> value(TypeInfo<V> value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMapTypeInfo<K, V> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMapTypeInfo(null, this.key, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build MapTypeInfo, some of required attributes are not set " + attributes;
        }
    }
}

