/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import de.flapdoodle.types.ImmutablePair;
import java.util.function.Function;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Pair<FIRST, SECOND> {
    @Value.Parameter
    public abstract FIRST first();

    @Value.Parameter
    public abstract SECOND second();

    public <T> Pair<T, SECOND> mapFirst(Function<FIRST, T> transformation) {
        return Pair.of(transformation.apply(this.first()), this.second());
    }

    public <T> Pair<FIRST, T> mapSecond(Function<SECOND, T> transformation) {
        return Pair.of(this.first(), transformation.apply(this.second()));
    }

    public <FIRST_MAPPED, SECOND_MAPPED> Pair<FIRST_MAPPED, SECOND_MAPPED> map(Function<FIRST, FIRST_MAPPED> first, Function<SECOND, SECOND_MAPPED> second) {
        return this.mapFirst(first).mapSecond(second);
    }

    public static <FIRST, SECOND> Pair<FIRST, SECOND> of(FIRST first, SECOND second) {
        return ImmutablePair.of(first, second);
    }
}

