/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo.tests;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import de.flapdoodle.embedmongo.MongoDBRuntime;
import de.flapdoodle.embedmongo.MongodExecutable;
import de.flapdoodle.embedmongo.MongodProcess;
import de.flapdoodle.embedmongo.config.MongodConfig;
import de.flapdoodle.embedmongo.config.RuntimeConfig;
import de.flapdoodle.embedmongo.distribution.IVersion;
import de.flapdoodle.embedmongo.distribution.Version;
import de.flapdoodle.embedmongo.runtime.Network;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.logging.Logger;

public class MongodForTestsFactory {
    private static Logger logger = Logger.getLogger(MongodForTestsFactory.class.getName());
    private final MongodExecutable mongodExecutable;
    private final MongodProcess mongodProcess;

    public static MongodForTestsFactory with(IVersion version) throws IOException {
        return new MongodForTestsFactory(version);
    }

    public MongodForTestsFactory() throws IOException {
        this(Version.Main.V2_0);
    }

    public MongodForTestsFactory(IVersion version) throws IOException {
        MongoDBRuntime runtime = MongoDBRuntime.getInstance(RuntimeConfig.getInstance(logger));
        this.mongodExecutable = runtime.prepare(new MongodConfig(version, Network.getFreeServerPort(), Network.localhostIsIPv6()));
        this.mongodProcess = this.mongodExecutable.start();
    }

    public Mongo newMongo() throws UnknownHostException, MongoException {
        return new Mongo(new ServerAddress(Network.getLocalHost(), this.mongodProcess.getConfig().getPort()));
    }

    public DB newDB(Mongo mongo) {
        return mongo.getDB(UUID.randomUUID().toString());
    }

    public void shutdown() {
        this.mongodProcess.stop();
        this.mongodExecutable.cleanup();
    }
}

