/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.store.DownloadCache;
import de.flapdoodle.embed.process.store.DownloadCacheGuessStorePath;
import de.flapdoodle.hash.Hasher;
import de.flapdoodle.types.Try;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.regex.Pattern;

public class LocalDownloadCache
implements DownloadCache,
DownloadCacheGuessStorePath {
    private final Path baseDir;
    private static final Pattern PATH_SEP_MATCHER = Pattern.compile("[/\\\\]+");
    private static final Pattern UNWANTED_CHARS_MATCHER = Pattern.compile("[^a-zA-Z0-9]+");

    public LocalDownloadCache(Path baseDir) {
        this.baseDir = baseDir;
        if (!Files.exists(baseDir, new LinkOption[0])) {
            Try.run(() -> Files.createDirectory(baseDir, new FileAttribute[0]));
        }
    }

    @Override
    public Path archivePath(URL url, ArchiveType archiveType) {
        return LocalDownloadCache.resolve(this.baseDir, url, archiveType);
    }

    @Override
    public Optional<Path> archiveFor(URL url, ArchiveType archiveType) {
        Path arcFile = this.archivePath(url, archiveType);
        return Files.isReadable(arcFile) ? Optional.of(arcFile) : Optional.empty();
    }

    @Override
    public Path store(URL url, ArchiveType archiveType, Path archive) throws IOException {
        Path arcFile = this.archivePath(url, archiveType);
        Path arcDirectory = arcFile.getParent();
        Preconditions.checkArgument((arcDirectory != null ? 1 : 0) != 0, (String)"no parent directory for %s", (Object[])new Object[]{arcFile});
        if (!Files.exists(arcDirectory, new LinkOption[0])) {
            Files.createDirectories(arcDirectory, new FileAttribute[0]);
        }
        if (Files.exists(arcFile, new LinkOption[0])) {
            Preconditions.checkArgument((boolean)LocalDownloadCache.fileContentIsTheSame(archive, arcFile), (String)"archive for %s:%s already exists with different content (%s)", (Object[])new Object[]{url, archiveType, arcFile});
            return arcFile;
        }
        return Files.copy(archive, arcFile, StandardCopyOption.COPY_ATTRIBUTES);
    }

    static Path resolve(Path base, URL url, ArchiveType archiveType) {
        String serverPart = LocalDownloadCache.serverPart(url);
        String pathPart = LocalDownloadCache.pathPart(url);
        Preconditions.checkArgument((boolean)url.toString().equals(serverPart + pathPart), (String)"parts missing: '%s' != '%s'+'%s'", (Object[])new Object[]{url, serverPart, pathPart});
        return base.resolve(LocalDownloadCache.sanitize(serverPart)).resolve(Hasher.md5Instance().update(serverPart).hashAsString()).resolve(LocalDownloadCache.sanitize(pathPart)).resolve(Hasher.instance().update(pathPart).hashAsString()).resolve("archive." + LocalDownloadCache.asExtension(archiveType));
    }

    static String sanitize(String src) {
        String strippedFromPathSeparator = PATH_SEP_MATCHER.matcher(src).replaceAll("");
        return UNWANTED_CHARS_MATCHER.matcher(strippedFromPathSeparator).replaceAll("-");
    }

    private static String serverPart(URL url) {
        boolean portIsPartOfTheUrl = url.getPort() != -1 && url.getPort() != url.getDefaultPort();
        return url.getProtocol() + "://" + url.getHost() + (portIsPartOfTheUrl ? ":" + url.getPort() : "");
    }

    private static String pathPart(URL url) {
        return url.getPath() + (url.getQuery() != null ? "?" + url.getQuery() : "");
    }

    private static String asExtension(ArchiveType archiveType) {
        switch (archiveType) {
            case ZIP: {
                return "zip";
            }
            case TGZ: {
                return "tgz";
            }
            case TBZ2: {
                return "tbz2";
            }
            case TXZ: {
                return "txz";
            }
            case EXE: {
                return "exe";
            }
        }
        throw new IllegalArgumentException("Unknown archiveType: " + (Object)((Object)archiveType));
    }

    /*
     * Exception decompiling
     */
    private static boolean fileContentIsTheSame(Path first, Path second) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

