/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.io.directories.PersistentDir;
import de.flapdoodle.embed.process.io.directories.TempDir;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.embed.process.io.progress.StandardConsoleProgressListener;
import de.flapdoodle.embed.process.store.ContentHashExtractedFileSetStore;
import de.flapdoodle.embed.process.store.DownloadCache;
import de.flapdoodle.embed.process.store.ExtractedFileSetStore;
import de.flapdoodle.embed.process.store.LocalDownloadCache;
import de.flapdoodle.embed.process.transitions.Directories;
import de.flapdoodle.embed.process.transitions.DownloadPackage;
import de.flapdoodle.embed.process.transitions.Executer;
import de.flapdoodle.embed.process.transitions.ExtractPackage;
import de.flapdoodle.embed.process.transitions.ImmutableProcessFactory;
import de.flapdoodle.embed.process.transitions.InitTempDirectory;
import de.flapdoodle.embed.process.types.Archive;
import de.flapdoodle.embed.process.types.ExecutedProcess;
import de.flapdoodle.embed.process.types.Name;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.embed.process.types.ProcessConfig;
import de.flapdoodle.embed.process.types.ProcessEnv;
import de.flapdoodle.embed.process.types.ProcessWorkingDir;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.TransitionWalker;
import de.flapdoodle.reverse.Transitions;
import de.flapdoodle.reverse.transitions.Derive;
import de.flapdoodle.reverse.transitions.Start;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.function.Function;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ProcessFactory {
    public abstract Version version();

    protected abstract Transition<Name> name();

    @Value.Default
    protected Transition<TempDir> initTempDirectory() {
        return InitTempDirectory.withPlatformTempRandomSubDir();
    }

    @Value.Default
    protected Transition<ProcessWorkingDir> processWorkingDir() {
        return Derive.given(TempDir.class).state(ProcessWorkingDir.class).with(Directories.deleteOnTearDown(TempDir.createDirectoryWith("workDir", new FileAttribute[0]), ProcessWorkingDir::of));
    }

    @Value.Default
    protected Start<ProcessConfig> processConfig() {
        return Start.to(ProcessConfig.class).initializedWith((Object)ProcessConfig.defaults()).withTransitionLabel("create default");
    }

    @Value.Default
    protected Transition<ProcessEnv> processEnv() {
        return Start.to(ProcessEnv.class).initializedWith((Object)ProcessEnv.of(Collections.emptyMap())).withTransitionLabel("create empty env");
    }

    protected abstract Transition<ProcessArguments> processArguments();

    @Value.Default
    protected Transition<ProcessOutput> processOutput() {
        return Derive.given(Name.class).state(ProcessOutput.class).deriveBy(name -> ProcessOutput.namedConsole(name.value())).withTransitionLabel("create named console");
    }

    @Value.Default
    protected Transition<ProgressListener> progressListener() {
        return Start.to(ProgressListener.class).providedBy(StandardConsoleProgressListener::new).withTransitionLabel("progressListener");
    }

    @Value.Default
    protected Transition<SupportConfig> supportConfig() {
        return Start.to(SupportConfig.class).initializedWith((Object)SupportConfig.generic());
    }

    protected abstract Transition<PersistentDir> persistentBaseDir();

    @Value.Default
    protected Transition<DownloadCache> downloadCache() {
        return Derive.given(PersistentDir.class).state(DownloadCache.class).deriveBy(storeBaseDir -> new LocalDownloadCache(((Path)storeBaseDir.value()).resolve("archives"))).withTransitionLabel("downloadCache");
    }

    @Value.Default
    protected Transition<ExtractedFileSetStore> extractedFileSetStore() {
        return Derive.given(PersistentDir.class).state(ExtractedFileSetStore.class).deriveBy(baseDir -> new ContentHashExtractedFileSetStore(((Path)baseDir.value()).resolve("fileSets"))).withTransitionLabel("extractedFileSetStore");
    }

    @Value.Default
    protected Transition<ExtractedFileSet> extractPackage() {
        return ExtractPackage.withDefaults().withExtractedFileSetStore((StateID<ExtractedFileSetStore>)StateID.of(ExtractedFileSetStore.class));
    }

    @Value.Default
    protected Transition<Archive> downloadPackage() {
        return DownloadPackage.withDefaults();
    }

    @Value.Default
    protected Transition<Distribution> distribution() {
        return Derive.given(Version.class).state(Distribution.class).deriveBy(Distribution::detectFor);
    }

    protected abstract Function<Distribution, Package> packageInformation();

    @Value.Default
    protected Transition<ExecutedProcess> executer() {
        return Executer.withDefaults();
    }

    @Value.Auxiliary
    public Transitions transitions() {
        return Transitions.from((Transition[])new Transition[]{this.initTempDirectory(), this.processWorkingDir(), this.name(), Start.to(Version.class).initializedWith((Object)this.version()), this.supportConfig(), this.processConfig(), this.processEnv(), this.processArguments(), this.processOutput(), this.progressListener(), this.persistentBaseDir(), Derive.given(Distribution.class).state(Package.class).deriveBy(this.packageInformation()), this.distribution(), this.downloadCache(), this.extractedFileSetStore(), this.extractPackage(), this.downloadPackage(), this.executer()});
    }

    @Value.Auxiliary
    public TransitionWalker walker() {
        return this.transitions().walker();
    }

    public static ImmutableProcessFactory.Builder builder() {
        return ImmutableProcessFactory.builder();
    }
}

