/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.archives;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.process.archives.AbstractExtractFileSet;
import de.flapdoodle.embed.process.archives.ArchiveStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import org.apache.commons.compress.archivers.ArchiveEntry;

public class SingleFileAdapter
extends AbstractExtractFileSet {
    @Override
    protected ArchiveStream archiveStream(Path source) throws IOException {
        return new SingleFileAsArchiveWrapper(source);
    }

    static class SingleFileEntryWrapper
    implements ArchiveEntry {
        private final File wrapped;
        private final Date lastModified;
        private final long length;
        private final boolean isDirectory;
        private FileInputStream inputStream;

        public SingleFileEntryWrapper(File wrapped) throws IOException {
            this.wrapped = wrapped;
            BasicFileAttributes attr = Files.readAttributes(wrapped.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            this.lastModified = Date.from(attr.lastModifiedTime().toInstant());
            this.length = attr.size();
            this.isDirectory = attr.isDirectory();
        }

        public String getName() {
            return this.wrapped.getName();
        }

        public long getSize() {
            return this.length;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public Date getLastModifiedDate() {
            return this.lastModified;
        }

        public InputStream inputStream() throws FileNotFoundException {
            Preconditions.checkArgument((this.inputStream == null ? 1 : 0) != 0, (String)"inputStream already created", (Object[])new Object[0]);
            this.inputStream = new FileInputStream(this.wrapped);
            return this.inputStream;
        }

        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
    }

    static class SingleFileAsArchiveWrapper
    implements ArchiveStream {
        private final SingleFileEntryWrapper singleFile;
        private boolean nextCalled = false;

        public SingleFileAsArchiveWrapper(Path singleFile) throws IOException {
            this.singleFile = new SingleFileEntryWrapper(singleFile.toFile());
        }

        @Override
        public ArchiveEntry getNextEntry() throws IOException {
            if (!this.nextCalled) {
                this.nextCalled = true;
                return this.singleFile;
            }
            return null;
        }

        @Override
        public InputStream asStream(ArchiveEntry entry) throws IOException {
            Preconditions.checkArgument((entry == this.singleFile ? 1 : 0) != 0, (String)"unexpected entry: %s", (Object[])new Object[]{entry});
            return this.singleFile.inputStream();
        }

        @Override
        public void close() throws IOException {
            this.singleFile.close();
        }

        @Override
        public boolean canReadEntryData(ArchiveEntry entry) {
            return entry == this.singleFile;
        }
    }
}

