/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.io.directories.TempDir;
import de.flapdoodle.embed.process.transitions.InitTempDirectory;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;

public final class ImmutableInitTempDirectory
extends InitTempDirectory {
    private final Supplier<TempDir> tempDirFactory;
    private final boolean deleteIfEmpty;
    private final boolean forceDelete;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInitTempDirectory(Builder builder) {
        if (builder.tempDirFactory != null) {
            this.initShim.tempDirFactory(builder.tempDirFactory);
        }
        if (builder.deleteIfEmptyIsSet()) {
            this.initShim.deleteIfEmpty(builder.deleteIfEmpty);
        }
        if (builder.forceDeleteIsSet()) {
            this.initShim.forceDelete(builder.forceDelete);
        }
        this.tempDirFactory = this.initShim.tempDirFactory();
        this.deleteIfEmpty = this.initShim.deleteIfEmpty();
        this.forceDelete = this.initShim.forceDelete();
        this.initShim = null;
    }

    private ImmutableInitTempDirectory(Supplier<TempDir> tempDirFactory, boolean deleteIfEmpty, boolean forceDelete) {
        this.tempDirFactory = tempDirFactory;
        this.deleteIfEmpty = deleteIfEmpty;
        this.forceDelete = forceDelete;
        this.initShim = null;
    }

    @Override
    protected Supplier<TempDir> tempDirFactory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tempDirFactory() : this.tempDirFactory;
    }

    @Override
    protected boolean deleteIfEmpty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deleteIfEmpty() : this.deleteIfEmpty;
    }

    @Override
    protected boolean forceDelete() {
        InitShim shim = this.initShim;
        return shim != null ? shim.forceDelete() : this.forceDelete;
    }

    public final ImmutableInitTempDirectory withTempDirFactory(Supplier<TempDir> value) {
        if (this.tempDirFactory == value) {
            return this;
        }
        Supplier<TempDir> newValue = Objects.requireNonNull(value, "tempDirFactory");
        return new ImmutableInitTempDirectory(newValue, this.deleteIfEmpty, this.forceDelete);
    }

    public final ImmutableInitTempDirectory withDeleteIfEmpty(boolean value) {
        if (this.deleteIfEmpty == value) {
            return this;
        }
        return new ImmutableInitTempDirectory(this.tempDirFactory, value, this.forceDelete);
    }

    public final ImmutableInitTempDirectory withForceDelete(boolean value) {
        if (this.forceDelete == value) {
            return this;
        }
        return new ImmutableInitTempDirectory(this.tempDirFactory, this.deleteIfEmpty, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInitTempDirectory && this.equalsByValue((ImmutableInitTempDirectory)another);
    }

    private boolean equalsByValue(ImmutableInitTempDirectory another) {
        return this.tempDirFactory.equals(another.tempDirFactory) && this.deleteIfEmpty == another.deleteIfEmpty && this.forceDelete == another.forceDelete;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tempDirFactory.hashCode();
        h += (h << 5) + Boolean.hashCode(this.deleteIfEmpty);
        h += (h << 5) + Boolean.hashCode(this.forceDelete);
        return h;
    }

    public String toString() {
        return "InitTempDirectory{tempDirFactory=" + this.tempDirFactory + ", deleteIfEmpty=" + this.deleteIfEmpty + ", forceDelete=" + this.forceDelete + "}";
    }

    public static ImmutableInitTempDirectory copyOf(InitTempDirectory instance) {
        if (instance instanceof ImmutableInitTempDirectory) {
            return (ImmutableInitTempDirectory)instance;
        }
        return ImmutableInitTempDirectory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_DELETE_IF_EMPTY = 1L;
        private static final long OPT_BIT_FORCE_DELETE = 2L;
        private long optBits;
        private Supplier<TempDir> tempDirFactory;
        private boolean deleteIfEmpty;
        private boolean forceDelete;

        private Builder() {
        }

        public final Builder from(InitTempDirectory instance) {
            Objects.requireNonNull(instance, "instance");
            this.tempDirFactory(instance.tempDirFactory());
            this.deleteIfEmpty(instance.deleteIfEmpty());
            this.forceDelete(instance.forceDelete());
            return this;
        }

        public final Builder tempDirFactory(Supplier<TempDir> tempDirFactory) {
            this.tempDirFactory = Objects.requireNonNull(tempDirFactory, "tempDirFactory");
            return this;
        }

        public final Builder deleteIfEmpty(boolean deleteIfEmpty) {
            this.deleteIfEmpty = deleteIfEmpty;
            this.optBits |= 1L;
            return this;
        }

        public final Builder forceDelete(boolean forceDelete) {
            this.forceDelete = forceDelete;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableInitTempDirectory build() {
            return new ImmutableInitTempDirectory(this);
        }

        private boolean deleteIfEmptyIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean forceDeleteIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte tempDirFactoryBuildStage = 0;
        private Supplier<TempDir> tempDirFactory;
        private byte deleteIfEmptyBuildStage = 0;
        private boolean deleteIfEmpty;
        private byte forceDeleteBuildStage = 0;
        private boolean forceDelete;

        private InitShim() {
        }

        Supplier<TempDir> tempDirFactory() {
            if (this.tempDirFactoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tempDirFactoryBuildStage == 0) {
                this.tempDirFactoryBuildStage = (byte)-1;
                Supplier computedValue = ImmutableInitTempDirectory.super.tempDirFactory();
                this.tempDirFactory = Objects.requireNonNull(computedValue, "tempDirFactory");
                this.tempDirFactoryBuildStage = 1;
            }
            return this.tempDirFactory;
        }

        void tempDirFactory(Supplier<TempDir> tempDirFactory) {
            this.tempDirFactory = tempDirFactory;
            this.tempDirFactoryBuildStage = 1;
        }

        boolean deleteIfEmpty() {
            if (this.deleteIfEmptyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deleteIfEmptyBuildStage == 0) {
                boolean computedValue;
                this.deleteIfEmptyBuildStage = (byte)-1;
                this.deleteIfEmpty = computedValue = ImmutableInitTempDirectory.super.deleteIfEmpty();
                this.deleteIfEmptyBuildStage = 1;
            }
            return this.deleteIfEmpty;
        }

        void deleteIfEmpty(boolean deleteIfEmpty) {
            this.deleteIfEmpty = deleteIfEmpty;
            this.deleteIfEmptyBuildStage = 1;
        }

        boolean forceDelete() {
            if (this.forceDeleteBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forceDeleteBuildStage == 0) {
                boolean computedValue;
                this.forceDeleteBuildStage = (byte)-1;
                this.forceDelete = computedValue = ImmutableInitTempDirectory.super.forceDelete();
                this.forceDeleteBuildStage = 1;
            }
            return this.forceDelete;
        }

        void forceDelete(boolean forceDelete) {
            this.forceDelete = forceDelete;
            this.forceDeleteBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.tempDirFactoryBuildStage == -1) {
                attributes.add("tempDirFactory");
            }
            if (this.deleteIfEmptyBuildStage == -1) {
                attributes.add("deleteIfEmpty");
            }
            if (this.forceDeleteBuildStage == -1) {
                attributes.add("forceDelete");
            }
            return "Cannot build InitTempDirectory, attribute initializers form cycle " + attributes;
        }
    }
}

