/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config;

import de.flapdoodle.embed.process.config.TimeoutConfig;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableTimeoutConfig
implements TimeoutConfig {
    private final int connectionTimeout;
    private final int readTimeout;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTimeoutConfig(Builder builder) {
        if (builder.connectionTimeoutIsSet()) {
            this.initShim.connectionTimeout(builder.connectionTimeout);
        }
        if (builder.readTimeoutIsSet()) {
            this.initShim.readTimeout(builder.readTimeout);
        }
        this.connectionTimeout = this.initShim.getConnectionTimeout();
        this.readTimeout = this.initShim.getReadTimeout();
        this.initShim = null;
    }

    private ImmutableTimeoutConfig(int connectionTimeout, int readTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.initShim = null;
    }

    private int getConnectionTimeoutInitialize() {
        return TimeoutConfig.super.getConnectionTimeout();
    }

    private int getReadTimeoutInitialize() {
        return TimeoutConfig.super.getReadTimeout();
    }

    @Override
    public int getConnectionTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getConnectionTimeout() : this.connectionTimeout;
    }

    @Override
    public int getReadTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getReadTimeout() : this.readTimeout;
    }

    public final ImmutableTimeoutConfig withConnectionTimeout(int value) {
        if (this.connectionTimeout == value) {
            return this;
        }
        return new ImmutableTimeoutConfig(value, this.readTimeout);
    }

    public final ImmutableTimeoutConfig withReadTimeout(int value) {
        if (this.readTimeout == value) {
            return this;
        }
        return new ImmutableTimeoutConfig(this.connectionTimeout, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTimeoutConfig && this.equalsByValue((ImmutableTimeoutConfig)another);
    }

    private boolean equalsByValue(ImmutableTimeoutConfig another) {
        return this.connectionTimeout == another.connectionTimeout && this.readTimeout == another.readTimeout;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.connectionTimeout;
        h += (h << 5) + this.readTimeout;
        return h;
    }

    public String toString() {
        return "TimeoutConfig{connectionTimeout=" + this.connectionTimeout + ", readTimeout=" + this.readTimeout + "}";
    }

    public static ImmutableTimeoutConfig copyOf(TimeoutConfig instance) {
        if (instance instanceof ImmutableTimeoutConfig) {
            return (ImmutableTimeoutConfig)instance;
        }
        return ImmutableTimeoutConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_CONNECTION_TIMEOUT = 1L;
        private static final long OPT_BIT_READ_TIMEOUT = 2L;
        private long optBits;
        private int connectionTimeout;
        private int readTimeout;

        private Builder() {
        }

        public final Builder from(TimeoutConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.connectionTimeout(instance.getConnectionTimeout());
            this.readTimeout(instance.getReadTimeout());
            return this;
        }

        public final Builder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            this.optBits |= 1L;
            return this;
        }

        public final Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableTimeoutConfig build() {
            return new ImmutableTimeoutConfig(this);
        }

        private boolean connectionTimeoutIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean readTimeoutIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte connectionTimeoutBuildStage = 0;
        private int connectionTimeout;
        private byte readTimeoutBuildStage = 0;
        private int readTimeout;

        private InitShim() {
        }

        int getConnectionTimeout() {
            if (this.connectionTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.connectionTimeoutBuildStage == 0) {
                int computedValue;
                this.connectionTimeoutBuildStage = (byte)-1;
                this.connectionTimeout = computedValue = ImmutableTimeoutConfig.this.getConnectionTimeoutInitialize();
                this.connectionTimeoutBuildStage = 1;
            }
            return this.connectionTimeout;
        }

        void connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            this.connectionTimeoutBuildStage = 1;
        }

        int getReadTimeout() {
            if (this.readTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.readTimeoutBuildStage == 0) {
                int computedValue;
                this.readTimeoutBuildStage = (byte)-1;
                this.readTimeout = computedValue = ImmutableTimeoutConfig.this.getReadTimeoutInitialize();
                this.readTimeoutBuildStage = 1;
            }
            return this.readTimeout;
        }

        void readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            this.readTimeoutBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.connectionTimeoutBuildStage == -1) {
                attributes.add("connectionTimeout");
            }
            if (this.readTimeoutBuildStage == -1) {
                attributes.add("readTimeout");
            }
            return "Cannot build TimeoutConfig, attribute initializers form cycle " + attributes;
        }
    }
}

