/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.net;

import de.flapdoodle.embed.process.config.TimeoutConfig;
import de.flapdoodle.embed.process.net.DownloadToPath;
import de.flapdoodle.net.URLConnections;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Optional;

public abstract class UrlStreams {
    public static DownloadToPath asDownloadToPath() {
        return new Adapter();
    }

    public static void downloadTo(URLConnection connection, Path destination, DownloadToPath.DownloadCopyListener copyListener) throws IOException {
        URLConnections.downloadIntoFile((URLConnection)connection, (Path)destination, copyListener::downloaded);
    }

    public static URLConnection urlConnectionOf(URL url, String userAgent, TimeoutConfig timeoutConfig, Optional<Proxy> proxy) throws IOException {
        URLConnection openConnection;
        URLConnection uRLConnection = openConnection = proxy.isPresent() ? URLConnections.urlConnectionOf((URL)url, (Proxy)proxy.get()) : URLConnections.urlConnectionOf((URL)url);
        if (url.getUserInfo() != null) {
            openConnection.setRequestProperty("Authorization", "Basic " + new String(Base64.getEncoder().encode(url.getUserInfo().getBytes())));
        }
        openConnection.setRequestProperty("User-Agent", userAgent);
        openConnection.setConnectTimeout(timeoutConfig.getConnectionTimeout());
        openConnection.setReadTimeout(timeoutConfig.getReadTimeout());
        return openConnection;
    }

    static class Adapter
    implements DownloadToPath {
        Adapter() {
        }

        @Override
        public void download(URL downloadUrl, Path destination, Optional<Proxy> proxy, String userAgent, TimeoutConfig timeoutConfig, DownloadToPath.DownloadCopyListener copyListener) throws IOException {
            URLConnection connection = UrlStreams.urlConnectionOf(downloadUrl, userAgent, timeoutConfig, proxy);
            UrlStreams.downloadTo(connection, destination, copyListener);
        }
    }
}

