/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.transitions.ImmutableExecuter;
import de.flapdoodle.embed.process.transitions.RunAProcess;
import de.flapdoodle.embed.process.types.ExecutedProcess;
import de.flapdoodle.embed.process.types.ExecutedProcessFactory;
import de.flapdoodle.embed.process.types.ExecutedProcessImpl;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.embed.process.types.ProcessConfig;
import de.flapdoodle.embed.process.types.ProcessEnv;
import de.flapdoodle.embed.process.types.ProcessWorkingDir;
import de.flapdoodle.embed.process.types.RunningProcess;
import de.flapdoodle.embed.process.types.RunningProcessFactory;
import de.flapdoodle.embed.process.types.RunningProcessImpl;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.naming.HasLabel;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.immutables.builder.Builder;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Executer<R extends RunningProcess, T extends ExecutedProcess>
extends RunAProcess<R, T>
implements HasLabel {
    @Value.Default
    public String transitionLabel() {
        return "Execute";
    }

    @Override
    @Value.Default
    public StateID<ExtractedFileSet> processExecutable() {
        return StateID.of(ExtractedFileSet.class);
    }

    @Override
    @Value.Default
    public StateID<ProcessConfig> processConfig() {
        return StateID.of(ProcessConfig.class);
    }

    @Override
    @Value.Default
    public StateID<ProcessEnv> processEnv() {
        return StateID.of(ProcessEnv.class);
    }

    @Override
    @Value.Default
    public StateID<ProcessArguments> arguments() {
        return StateID.of(ProcessArguments.class);
    }

    @Override
    @Value.Default
    public StateID<ProcessOutput> processOutput() {
        return StateID.of(ProcessOutput.class);
    }

    @Override
    @Value.Default
    public StateID<SupportConfig> supportConfig() {
        return StateID.of(SupportConfig.class);
    }

    public abstract StateID<T> destination();

    @Override
    @Builder.Parameter
    protected abstract RunningProcessFactory<R> runningProcessFactory();

    @Builder.Parameter
    protected abstract ExecutedProcessFactory<R, T> executedProcessFactory();

    @Override
    public Set<StateID<?>> sources() {
        return StateID.setOf((StateID[])new StateID[]{this.processWorkingDir(), this.processExecutable(), this.processConfig(), this.processEnv(), this.arguments(), this.processOutput(), this.supportConfig()});
    }

    public State<T> result(StateLookup lookup) {
        Path processWorkingDir = ((ProcessWorkingDir)lookup.of(this.processWorkingDir())).value();
        ExtractedFileSet fileSet = (ExtractedFileSet)lookup.of(this.processExecutable());
        Object arguments = ((ProcessArguments)lookup.of(this.arguments())).value();
        Object environment = ((ProcessEnv)lookup.of(this.processEnv())).value();
        ProcessConfig processConfig = (ProcessConfig)lookup.of(this.processConfig());
        ProcessOutput processOutput = (ProcessOutput)lookup.of(this.processOutput());
        SupportConfig supportConfig = (SupportConfig)lookup.of(this.supportConfig());
        try {
            R running = RunningProcess.start(this.runningProcessFactory(), processWorkingDir, fileSet.executable(), (List<String>)arguments, (Map<String, String>)environment, processConfig, processOutput, supportConfig);
            T executedProcess = this.executedProcessFactory().stop(running);
            return State.of(executedProcess, (TearDown[])new TearDown[0]);
        }
        catch (IOException ix) {
            throw new RuntimeException("could not execute process", ix);
        }
    }

    public static <R extends RunningProcess, T extends ExecutedProcess> ImmutableExecuter.Builder<R, T> with(RunningProcessFactory<R> runningProcessFactory, ExecutedProcessFactory<R, T> executedProcessFactory) {
        return ImmutableExecuter.builder(runningProcessFactory, executedProcessFactory);
    }

    public static ImmutableExecuter<RunningProcessImpl, ExecutedProcess> withDefaults() {
        return Executer.with(RunningProcessImpl::new, ExecutedProcessImpl::stop).destination((StateID<ExecutedProcess>)StateID.of(ExecutedProcess.class)).build();
    }
}

