/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="ExtractedFileSet", generator="Immutables")
public final class ImmutableExtractedFileSet
extends ExtractedFileSet {
    private final File baseDir;
    private final File executable;
    private final Set<File> libraryFiles;
    private final boolean baseDirIsGenerated;

    private ImmutableExtractedFileSet(File baseDir, File executable, Set<File> libraryFiles, boolean baseDirIsGenerated) {
        this.baseDir = baseDir;
        this.executable = executable;
        this.libraryFiles = libraryFiles;
        this.baseDirIsGenerated = baseDirIsGenerated;
    }

    @Override
    public File baseDir() {
        return this.baseDir;
    }

    @Override
    public File executable() {
        return this.executable;
    }

    @Override
    public Set<File> libraryFiles() {
        return this.libraryFiles;
    }

    @Override
    public boolean baseDirIsGenerated() {
        return this.baseDirIsGenerated;
    }

    public final ImmutableExtractedFileSet withBaseDir(File value) {
        if (this.baseDir == value) {
            return this;
        }
        File newValue = Objects.requireNonNull(value, "baseDir");
        return new ImmutableExtractedFileSet(newValue, this.executable, this.libraryFiles, this.baseDirIsGenerated);
    }

    public final ImmutableExtractedFileSet withExecutable(File value) {
        if (this.executable == value) {
            return this;
        }
        File newValue = Objects.requireNonNull(value, "executable");
        return new ImmutableExtractedFileSet(this.baseDir, newValue, this.libraryFiles, this.baseDirIsGenerated);
    }

    public final ImmutableExtractedFileSet withLibraryFiles(File ... elements) {
        Set<File> newValue = ImmutableExtractedFileSet.createUnmodifiableSet(ImmutableExtractedFileSet.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableExtractedFileSet(this.baseDir, this.executable, newValue, this.baseDirIsGenerated);
    }

    public final ImmutableExtractedFileSet withLibraryFiles(Iterable<? extends File> elements) {
        if (this.libraryFiles == elements) {
            return this;
        }
        Set<File> newValue = ImmutableExtractedFileSet.createUnmodifiableSet(ImmutableExtractedFileSet.createSafeList(elements, true, false));
        return new ImmutableExtractedFileSet(this.baseDir, this.executable, newValue, this.baseDirIsGenerated);
    }

    public final ImmutableExtractedFileSet withBaseDirIsGenerated(boolean value) {
        if (this.baseDirIsGenerated == value) {
            return this;
        }
        return new ImmutableExtractedFileSet(this.baseDir, this.executable, this.libraryFiles, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExtractedFileSet && this.equalTo(0, (ImmutableExtractedFileSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableExtractedFileSet another) {
        return this.baseDir.equals(another.baseDir) && this.executable.equals(another.executable) && this.libraryFiles.equals(another.libraryFiles) && this.baseDirIsGenerated == another.baseDirIsGenerated;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.baseDir.hashCode();
        h += (h << 5) + this.executable.hashCode();
        h += (h << 5) + this.libraryFiles.hashCode();
        h += (h << 5) + Boolean.hashCode(this.baseDirIsGenerated);
        return h;
    }

    public String toString() {
        return "ExtractedFileSet{baseDir=" + this.baseDir + ", executable=" + this.executable + ", libraryFiles=" + this.libraryFiles + ", baseDirIsGenerated=" + this.baseDirIsGenerated + "}";
    }

    public static ImmutableExtractedFileSet copyOf(ExtractedFileSet instance) {
        if (instance instanceof ImmutableExtractedFileSet) {
            return (ImmutableExtractedFileSet)instance;
        }
        return ImmutableExtractedFileSet.builder().baseDir(instance.baseDir()).executable(instance.executable()).addAllLibraryFiles(instance.libraryFiles()).baseDirIsGenerated(instance.baseDirIsGenerated()).build();
    }

    public static Builder builder(File baseDir) {
        return new Builder(baseDir);
    }

    static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="ExtractedFileSet", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_BASE_DIR = 1L;
        private static final long INIT_BIT_EXECUTABLE = 2L;
        private static final long INIT_BIT_BASE_DIR_IS_GENERATED = 4L;
        private long initBits = 7L;
        private File baseDir;
        private File executable;
        private final List<File> libraryFiles = new ArrayList<File>();
        private boolean baseDirIsGenerated;

        private Builder(File baseDir) {
            this.baseDir(baseDir);
        }

        private Builder() {
        }

        final Builder baseDir(File baseDir) {
            Builder.checkNotIsSet(this.baseDirIsSet(), "baseDir");
            this.baseDir = Objects.requireNonNull(baseDir, "baseDir");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder executable(File executable) {
            Builder.checkNotIsSet(this.executableIsSet(), "executable");
            this.executable = Objects.requireNonNull(executable, "executable");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addLibraryFiles(File element) {
            this.libraryFiles.add(Objects.requireNonNull(element, "libraryFiles element"));
            return this;
        }

        public final Builder addLibraryFiles(File ... elements) {
            for (File element : elements) {
                this.libraryFiles.add(Objects.requireNonNull(element, "libraryFiles element"));
            }
            return this;
        }

        public final Builder addAllLibraryFiles(Iterable<? extends File> elements) {
            for (File file : elements) {
                this.libraryFiles.add(Objects.requireNonNull(file, "libraryFiles element"));
            }
            return this;
        }

        public final Builder baseDirIsGenerated(boolean baseDirIsGenerated) {
            Builder.checkNotIsSet(this.baseDirIsGeneratedIsSet(), "baseDirIsGenerated");
            this.baseDirIsGenerated = baseDirIsGenerated;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableExtractedFileSet build() {
            this.checkRequiredAttributes();
            return new ImmutableExtractedFileSet(this.baseDir, this.executable, ImmutableExtractedFileSet.createUnmodifiableSet(this.libraryFiles), this.baseDirIsGenerated);
        }

        private boolean baseDirIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean executableIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean baseDirIsGeneratedIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ExtractedFileSet is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.baseDirIsSet()) {
                attributes.add("baseDir");
            }
            if (!this.executableIsSet()) {
                attributes.add("executable");
            }
            if (!this.baseDirIsGeneratedIsSet()) {
                attributes.add("baseDirIsGenerated");
            }
            return "Cannot build ExtractedFileSet, some of required attributes are not set " + attributes;
        }
    }
}

