/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.DownloadConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.file.Files;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;

class LocalArtifactStore {
    LocalArtifactStore() {
    }

    public static boolean checkArtifact(DownloadConfig runtime, Distribution distribution) {
        return LocalArtifactStore.getArtifact(runtime, distribution) != null;
    }

    public static boolean store(DownloadConfig runtime, Distribution distribution, File download) {
        File dir = LocalArtifactStore.createOrGetBaseDir(runtime);
        String artifactFileName = runtime.getPackageResolver().packageFor(distribution).archivePath();
        File artifactFile = new File(dir, artifactFileName);
        LocalArtifactStore.createOrCheckDir(artifactFile.getParentFile());
        try {
            Files.moveFile(download, artifactFile);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException iox) {
            throw new IllegalArgumentException("Could not move " + download + " to " + artifactFile, iox);
        }
        File checkFile = new File(dir, artifactFileName);
        return checkFile.exists() && checkFile.isFile() && checkFile.canRead();
    }

    private static File createOrGetBaseDir(DownloadConfig runtime) {
        File dir = runtime.getArtifactStorePath().asFile();
        LocalArtifactStore.createOrCheckDir(dir);
        return dir;
    }

    private static void createOrCheckDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalArgumentException("Could NOT create Directory " + dir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("" + dir + " is not a Directory");
        }
    }

    public static File getArtifact(DownloadConfig runtime, Distribution distribution) {
        File dir = LocalArtifactStore.createOrGetBaseDir(runtime);
        File artifactFile = new File(dir, runtime.getPackageResolver().packageFor(distribution).archivePath());
        if (artifactFile.exists() && artifactFile.isFile()) {
            return artifactFile;
        }
        return null;
    }
}

