/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.builder.IProperty;
import de.flapdoodle.embed.process.builder.TypedProperty;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.extract.DirectoryAndExecutableNaming;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.store.ArtifactStoreBuilder;
import de.flapdoodle.embed.process.store.ExtractedArtifactStore;
import de.flapdoodle.embed.process.store.IArtifactStore;
import de.flapdoodle.embed.process.store.IDownloader;

public class ExtractedArtifactStoreBuilder
extends ArtifactStoreBuilder {
    protected static final TypedProperty<IDirectory> EXTRACT_DIR_FACTORY = TypedProperty.with("ExtractDir", IDirectory.class);
    protected static final TypedProperty<ITempNaming> EXTRACT_EXECUTABLE_NAMING = TypedProperty.with("ExtractExecutableNaming", ITempNaming.class);

    @Override
    public ExtractedArtifactStoreBuilder tempDir(IDirectory tempDirFactory) {
        super.tempDir(tempDirFactory);
        return this;
    }

    @Override
    @Deprecated
    public ArtifactStoreBuilder useCache(boolean cache) {
        throw new RuntimeException("no need to cache anything");
    }

    @Override
    public ExtractedArtifactStoreBuilder download(IDownloadConfig downloadConfig) {
        super.download(downloadConfig);
        return this;
    }

    @Override
    public ExtractedArtifactStoreBuilder downloader(IDownloader downloader) {
        super.downloader(downloader);
        return this;
    }

    @Override
    public ExtractedArtifactStoreBuilder executableNaming(ITempNaming execNaming) {
        super.executableNaming(execNaming);
        return this;
    }

    public ExtractedArtifactStoreBuilder extractExecutableNaming(ITempNaming execNaming) {
        this.set(EXTRACT_EXECUTABLE_NAMING, execNaming);
        return this;
    }

    public ExtractedArtifactStoreBuilder extractDir(IDirectory tempDirFactory) {
        this.set(EXTRACT_DIR_FACTORY, tempDirFactory);
        return this;
    }

    protected IProperty<IDirectory> extractDir() {
        return this.property(EXTRACT_DIR_FACTORY);
    }

    protected IProperty<ITempNaming> extractExecutableNaming() {
        return this.property(EXTRACT_EXECUTABLE_NAMING);
    }

    @Override
    public IArtifactStore build() {
        DirectoryAndExecutableNaming extract = new DirectoryAndExecutableNaming(this.get(EXTRACT_DIR_FACTORY), this.get(EXTRACT_EXECUTABLE_NAMING));
        DirectoryAndExecutableNaming temp = new DirectoryAndExecutableNaming(this.tempDir().get(), this.executableNaming().get());
        return new ExtractedArtifactStore((IDownloadConfig)this.get(DOWNLOAD_CONFIG), (IDownloader)this.get(DOWNLOADER), extract, temp);
    }
}

