/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io.progress;

import de.flapdoodle.embed.process.io.progress.IProgressListener;
import org.slf4j.Logger;

public class Slf4jProgressListener
implements IProgressListener {
    private final Logger logger;
    private int lastPercent = -1;

    public Slf4jProgressListener(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void progress(String label, int percent) {
        if (percent != this.lastPercent && percent % 10 == 0) {
            this.logger.info("{} : {} %", (Object)label, (Object)percent);
        }
        this.lastPercent = percent;
    }

    @Override
    public void done(String label) {
        this.logger.info("{} : finished", (Object)label);
    }

    @Override
    public void start(String label) {
        this.logger.info("{} : starting...", (Object)label);
    }

    @Override
    public void info(String label, String message) {
        this.logger.info("{} : {}", (Object)label, (Object)message);
    }
}

