/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.extract.ExecutableFileAlreadyExistsException;
import de.flapdoodle.embed.process.extract.IArchiveEntry;
import de.flapdoodle.embed.process.extract.IExtractionMatch;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.file.FileAlreadyExistsException;
import de.flapdoodle.embed.process.io.file.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FilesToExtract {
    private final ArrayList<FileSet.Entry> _files;
    private final ITempNaming _executableNaming;
    private final File _dirFactoryResult;
    private final boolean _dirFactoryResultIsGenerated;

    public FilesToExtract(IDirectory dirFactory, ITempNaming executableNaming, FileSet fileSet) {
        if (dirFactory == null) {
            throw new NullPointerException("dirFactory is NULL");
        }
        if (executableNaming == null) {
            throw new NullPointerException("executableNaming is NULL");
        }
        if (fileSet == null) {
            throw new NullPointerException("fileSet is NULL");
        }
        this._files = new ArrayList<FileSet.Entry>(fileSet.entries());
        this._dirFactoryResult = dirFactory.asFile();
        this._dirFactoryResultIsGenerated = dirFactory.isGenerated();
        this._executableNaming = executableNaming;
    }

    public File baseDir() {
        return this._dirFactoryResult;
    }

    public boolean baseDirIsGenerated() {
        return this._dirFactoryResultIsGenerated;
    }

    public boolean nothingLeft() {
        return this._files.isEmpty();
    }

    public List<FileSet.Entry> files() {
        return Collections.unmodifiableList(this._files);
    }

    public IExtractionMatch find(IArchiveEntry entry) {
        FileSet.Entry found = null;
        if (!entry.isDirectory()) {
            for (FileSet.Entry e : this._files) {
                if (!e.matchingPattern().matcher(entry.getName()).matches()) continue;
                found = e;
                break;
            }
            if (found != null) {
                this._files.remove(found);
            }
        }
        return found != null ? new Match(this._dirFactoryResult, this._executableNaming, found) : null;
    }

    public static String fileName(FileSet.Entry entry) {
        return entry.destination();
    }

    public static String executableName(ITempNaming executableNaming, FileSet.Entry entry) {
        return executableNaming.nameFor("extract", FilesToExtract.fileName(entry));
    }

    static class Match
    implements IExtractionMatch {
        private final FileSet.Entry _entry;
        private final File _dirFactoryResult;
        private final ITempNaming _executableNaming;

        public Match(File dirFactoryResult, ITempNaming executableNaming, FileSet.Entry entry) {
            this._dirFactoryResult = dirFactoryResult;
            this._executableNaming = executableNaming;
            this._entry = entry;
        }

        @Override
        public FileType type() {
            return this._entry.type();
        }

        @Override
        public File write(InputStream source, long size) throws IOException {
            File destination;
            switch (this._entry.type()) {
                case Executable: {
                    try {
                        destination = Files.createTempFile(this._dirFactoryResult, FilesToExtract.executableName(this._executableNaming, this._entry));
                        break;
                    }
                    catch (FileAlreadyExistsException ex) {
                        throw new ExecutableFileAlreadyExistsException(ex);
                    }
                }
                default: {
                    destination = Files.createTempFile(this._dirFactoryResult, FilesToExtract.fileName(this._entry));
                }
            }
            Files.write(source, size, destination);
            switch (this._entry.type()) {
                case Executable: {
                    destination.setExecutable(true);
                }
            }
            return destination;
        }
    }
}

