/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.extract.ImmutableExtractedFileSet;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtractedFileSets {
    private static Logger logger = LoggerFactory.getLogger(ExtractedFileSets.class);

    private ExtractedFileSets() {
    }

    public static IExtractedFileSet copy(IExtractedFileSet src, IDirectory directory, ITempNaming executableNaming) throws IOException {
        File destination = directory.asFile();
        File baseDir = src.baseDir();
        File oldExe = src.executable();
        ImmutableExtractedFileSet.Builder builder = ImmutableExtractedFileSet.builder(destination).baseDirIsGenerated(directory.isGenerated());
        Path newExeFile = Files.copy(de.flapdoodle.embed.process.io.file.Files.fileOf(baseDir, oldExe).toPath(), de.flapdoodle.embed.process.io.file.Files.fileOf(destination, executableNaming.nameFor("extract", oldExe.getName())).toPath(), new CopyOption[0]);
        builder.executable(newExeFile.toFile());
        for (FileType type : EnumSet.complementOf(EnumSet.of(FileType.Executable))) {
            for (File srcFile : src.files(type)) {
                File destinationFile = de.flapdoodle.embed.process.io.file.Files.fileOf(destination, srcFile);
                de.flapdoodle.embed.process.io.file.Files.createOrCheckDir(destinationFile.getParentFile());
                Path newFile = Files.copy(de.flapdoodle.embed.process.io.file.Files.fileOf(baseDir, srcFile).toPath(), destinationFile.toPath(), new CopyOption[0]);
                builder.file(type, newFile.toFile());
            }
        }
        return builder.build();
    }

    public static void delete(IExtractedFileSet all) {
        for (FileType type : EnumSet.complementOf(EnumSet.of(FileType.Executable))) {
            for (File file : all.files(type)) {
                if (!file.exists() || de.flapdoodle.embed.process.io.file.Files.forceDelete(file)) continue;
                logger.warn("Could not delete {} NOW: {}", (Object)type, (Object)file);
            }
        }
        File exe = all.executable();
        if (exe.exists() && !de.flapdoodle.embed.process.io.file.Files.forceDelete(exe)) {
            logger.warn("Could not delete executable NOW: {}", (Object)exe);
        }
        if (all.baseDirIsGenerated() && !de.flapdoodle.embed.process.io.file.Files.forceDelete(all.baseDir())) {
            logger.warn("Could not delete generatedBaseDir: {}", (Object)all.baseDir());
        }
    }
}

