/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.mongo.commands.MongosArguments;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.transitions.CommandProcessArguments;
import de.flapdoodle.embed.mongo.transitions.ImmutableMongosProcessArguments;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.os.Platform;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.List;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public abstract class MongosProcessArguments
implements CommandProcessArguments<MongosArguments>,
HasLabel {
    @Value.Auxiliary
    public String transitionLabel() {
        return "Create mongod arguments";
    }

    @Value.Default
    public StateID<ProcessArguments> destination() {
        return StateID.of(ProcessArguments.class);
    }

    @Override
    @Value.Default
    public StateID<MongosArguments> arguments() {
        return StateID.of(MongosArguments.class);
    }

    @Value.Default
    public StateID<Platform> platform() {
        return StateID.of(Platform.class);
    }

    @Value.Default
    public StateID<Version> version() {
        return StateID.of(Version.class);
    }

    @Value.Default
    public StateID<Net> net() {
        return StateID.of(Net.class);
    }

    @Value.Auxiliary
    public Set<StateID<?>> sources() {
        return StateID.setOf((StateID[])new StateID[]{this.arguments(), this.platform(), this.version(), this.net()});
    }

    public State<ProcessArguments> result(StateLookup lookup) {
        MongosArguments arguments = (MongosArguments)lookup.of(this.arguments());
        Platform platform = (Platform)lookup.of(this.platform());
        Version version = (Version)lookup.of(this.version());
        Preconditions.checkArgument((boolean)(version instanceof IFeatureAwareVersion), (String)"invalid type: %s does not implement %s", (Object[])new Object[]{version, IFeatureAwareVersion.class});
        IFeatureAwareVersion featureAwareVersion = (IFeatureAwareVersion)version;
        Net net = (Net)lookup.of(this.net());
        List<String> commandLine = arguments.asArguments(platform, featureAwareVersion, net);
        return State.of((Object)ProcessArguments.of(commandLine), (TearDown[])new TearDown[0]);
    }

    public static ImmutableMongosProcessArguments withDefaults() {
        return MongosProcessArguments.builder().build();
    }

    public static ImmutableMongosProcessArguments.Builder builder() {
        return ImmutableMongosProcessArguments.builder();
    }
}

