package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.process.types.ExecutedProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Immutable implementation of {@link ExecutedMongoImportProcess}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExecutedMongoImportProcess.builder()}.
 */
@SuppressWarnings({"all"})
public final class ImmutableExecutedMongoImportProcess
    extends ExecutedMongoImportProcess {
  private final int returnCode;

  private ImmutableExecutedMongoImportProcess(int returnCode) {
    this.returnCode = returnCode;
  }

  /**
   * @return The value of the {@code returnCode} attribute
   */
  @Override
  public int returnCode() {
    return returnCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecutedMongoImportProcess#returnCode() returnCode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for returnCode
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableExecutedMongoImportProcess withReturnCode(int value) {
    if (this.returnCode == value) return this;
    return new ImmutableExecutedMongoImportProcess(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExecutedMongoImportProcess} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExecutedMongoImportProcess
        && equalsByValue((ImmutableExecutedMongoImportProcess) another);
  }

  private boolean equalsByValue(ImmutableExecutedMongoImportProcess another) {
    return returnCode == another.returnCode;
  }

  /**
   * Computes a hash code from attributes: {@code returnCode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + returnCode;
    return h;
  }

  /**
   * Prints the immutable value {@code ExecutedMongoImportProcess} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExecutedMongoImportProcess{"
        + "returnCode=" + returnCode
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExecutedMongoImportProcess} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExecutedMongoImportProcess instance
   */
  public static ImmutableExecutedMongoImportProcess copyOf(ExecutedMongoImportProcess instance) {
    if (instance instanceof ImmutableExecutedMongoImportProcess) {
      return (ImmutableExecutedMongoImportProcess) instance;
    }
    return ImmutableExecutedMongoImportProcess.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExecutedMongoImportProcess ImmutableExecutedMongoImportProcess}.
   * <pre>
   * ImmutableExecutedMongoImportProcess.builder()
   *    .returnCode(int) // required {@link ExecutedMongoImportProcess#returnCode() returnCode}
   *    .build();
   * </pre>
   * @return A new ImmutableExecutedMongoImportProcess builder
   */
  public static ImmutableExecutedMongoImportProcess.Builder builder() {
    return new ImmutableExecutedMongoImportProcess.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExecutedMongoImportProcess ImmutableExecutedMongoImportProcess}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_RETURN_CODE = 0x1L;
    private long initBits = 0x1L;

    private int returnCode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.process.types.ExecutedProcess} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExecutedProcess instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.transitions.ExecutedMongoImportProcess} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExecutedMongoImportProcess instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      long bits = 0;
      if (object instanceof ExecutedProcess) {
        ExecutedProcess instance = (ExecutedProcess) object;
        this.returnCode(instance.returnCode());
      }
    }

    /**
     * Initializes the value for the {@link ExecutedMongoImportProcess#returnCode() returnCode} attribute.
     * @param returnCode The value for returnCode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder returnCode(int returnCode) {
      this.returnCode = returnCode;
      initBits &= ~INIT_BIT_RETURN_CODE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExecutedMongoImportProcess ImmutableExecutedMongoImportProcess}.
     * @return An immutable instance of ExecutedMongoImportProcess
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExecutedMongoImportProcess build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExecutedMongoImportProcess(returnCode);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RETURN_CODE) != 0) attributes.add("returnCode");
      return "Cannot build ExecutedMongoImportProcess, some of required attributes are not set " + attributes;
    }
  }
}
