package de.flapdoodle.embed.mongo.types;

import java.util.Objects;

/**
 * Immutable implementation of {@link _StartTimeout}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code StartTimeout.of()}.
 */
@SuppressWarnings({"all"})
public final class StartTimeout extends de.flapdoodle.embed.mongo.types._StartTimeout {
  private final Long value;

  private StartTimeout(Long value) {
    this.value = Objects.requireNonNull(value, "value");
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public Long value() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code StartTimeout} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof StartTimeout
        && equalTo(0, (StartTimeout) another);
  }

  private boolean equalTo(int synthetic, StartTimeout another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code StartTimeout} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable StartTimeout instance
   */
  public static StartTimeout of(Long value) {
    return new StartTimeout(value);
  }
}
