/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.Net;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableNet
extends Net {
    private final String bindIp;
    private final int port;
    private final boolean isIpv6;

    private ImmutableNet(String bindIp, int port, boolean isIpv6) {
        this.bindIp = bindIp;
        this.port = port;
        this.isIpv6 = isIpv6;
    }

    @Override
    public Optional<String> getBindIp() {
        return Optional.ofNullable(this.bindIp);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isIpv6() {
        return this.isIpv6;
    }

    public final ImmutableNet withBindIp(String value) {
        String newValue = Objects.requireNonNull(value, "bindIp");
        if (Objects.equals(this.bindIp, newValue)) {
            return this;
        }
        return new ImmutableNet(newValue, this.port, this.isIpv6);
    }

    public final ImmutableNet withBindIp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.bindIp, value)) {
            return this;
        }
        return new ImmutableNet(value, this.port, this.isIpv6);
    }

    @Override
    public final ImmutableNet withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableNet(this.bindIp, value, this.isIpv6);
    }

    public final ImmutableNet withIsIpv6(boolean value) {
        if (this.isIpv6 == value) {
            return this;
        }
        return new ImmutableNet(this.bindIp, this.port, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNet && this.equalTo(0, (ImmutableNet)another);
    }

    private boolean equalTo(int synthetic, ImmutableNet another) {
        return Objects.equals(this.bindIp, another.bindIp) && this.port == another.port && this.isIpv6 == another.isIpv6;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.bindIp);
        h += (h << 5) + this.port;
        h += (h << 5) + Boolean.hashCode(this.isIpv6);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Net{");
        if (this.bindIp != null) {
            builder.append("bindIp=").append(this.bindIp);
        }
        if (builder.length() > 4) {
            builder.append(", ");
        }
        builder.append("port=").append(this.port);
        builder.append(", ");
        builder.append("isIpv6=").append(this.isIpv6);
        return builder.append("}").toString();
    }

    public static ImmutableNet copyOf(Net instance) {
        if (instance instanceof ImmutableNet) {
            return (ImmutableNet)instance;
        }
        return ImmutableNet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PORT = 1L;
        private static final long INIT_BIT_IS_IPV6 = 2L;
        private long initBits = 3L;
        private String bindIp;
        private int port;
        private boolean isIpv6;

        private Builder() {
        }

        public final Builder from(Net instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> bindIpOptional = instance.getBindIp();
            if (bindIpOptional.isPresent()) {
                this.bindIp(bindIpOptional);
            }
            this.port(instance.getPort());
            this.isIpv6(instance.isIpv6());
            return this;
        }

        public final Builder bindIp(String bindIp) {
            this.bindIp = Objects.requireNonNull(bindIp, "bindIp");
            return this;
        }

        public final Builder bindIp(Optional<String> bindIp) {
            this.bindIp = bindIp.orElse(null);
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder isIpv6(boolean isIpv6) {
            this.isIpv6 = isIpv6;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableNet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNet(this.bindIp, this.port, this.isIpv6);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("port");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("isIpv6");
            }
            return "Cannot build Net, some of required attributes are not set " + attributes;
        }
    }
}

