/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class Arguments {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<String> arguments = new ArrayList<String>();

        public List<String> build() {
            return Collections.unmodifiableList(new ArrayList<String>(this.arguments));
        }

        public Builder add(String ... parts) {
            for (String part : parts) {
                this.arguments.add(part);
            }
            return this;
        }

        public Builder addIf(boolean condition, String ... parts) {
            if (condition) {
                this.add(parts);
            }
            return this;
        }

        public Builder addIf(String key, Optional<String> value) {
            value.ifPresent(it -> this.add(key, (String)it));
            return this;
        }
    }
}

