/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.runtime;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.config.MongoCmdOptions;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.Storage;
import de.flapdoodle.embed.mongo.config.SupportConfig;
import de.flapdoodle.embed.mongo.distribution.Feature;
import de.flapdoodle.embed.mongo.runtime.AbstractMongo;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.runtime.NUMA;
import de.flapdoodle.os.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mongod
extends AbstractMongo {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mongod.class);
    private static final byte[] SHUTDOWN_COMMAND = new byte[]{88, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, -44, 7, 0, 0, 0, 0, 0, 0, 97, 100, 109, 105, 110, 46, 36, 99, 109, 100, 0, 0, 0, 0, 0, -1, -1, -1, -1, 44, 0, 0, 0, 16, 115, 104, 117, 116, 100, 111, 119, 110, 0, 1, 0, 0, 0, 8, 102, 111, 114, 99, 101, 0, 1, 16, 116, 105, 109, 101, 111, 117, 116, 83, 101, 99, 115, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0};
    private static final int SOCKET_TIMEOUT = 2000;
    private static final int CONNECT_TIMEOUT = 2000;
    private static final int BYTE_BUFFER_LENGTH = 512;
    private static final int WAITING_TIME_SHUTDOWN_IN_MS = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean sendShutdown(InetAddress hostname, int port) {
        Socket s;
        boolean tryToReadErrorResponse;
        block17: {
            if (!hostname.isLoopbackAddress()) {
                LOGGER.warn("---------------------------------------\nYour localhost ({}) is not a loopback adress\nWe can NOT send shutdown to mongod, because it is denied from remote.\n---------------------------------------\n", (Object)hostname.getHostAddress());
                return false;
            }
            tryToReadErrorResponse = false;
            s = new Socket();
            s.setSoTimeout(2000);
            s.connect(new InetSocketAddress(hostname, port), 2000);
            OutputStream outputStream = s.getOutputStream();
            outputStream.write(SHUTDOWN_COMMAND);
            outputStream.flush();
            tryToReadErrorResponse = true;
            InputStream inputStream = s.getInputStream();
            if (inputStream.read(new byte[512]) == -1) break block17;
            LOGGER.error("Got some response, should be an error message");
            boolean bl = false;
            try {
                s.close();
                Thread.sleep(100L);
            }
            catch (IOException | InterruptedException ix) {
                LOGGER.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
            }
            return bl;
        }
        boolean bl = true;
        try {
            s.close();
            Thread.sleep(100L);
        }
        catch (IOException | InterruptedException ix) {
            LOGGER.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
        }
        return bl;
        catch (IOException iox) {
            block18: {
                boolean bl2;
                try {
                    if (!tryToReadErrorResponse) break block18;
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    try {
                        s.close();
                        Thread.sleep(100L);
                    }
                    catch (IOException | InterruptedException ix) {
                        LOGGER.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
                    }
                    throw throwable;
                }
                try {
                    s.close();
                    Thread.sleep(100L);
                }
                catch (IOException | InterruptedException ix) {
                    LOGGER.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
                }
                return bl2;
            }
            LOGGER.warn("sendShutdown {}:{}", new Object[]{hostname, port, iox});
            try {
                s.close();
                Thread.sleep(100L);
            }
            catch (IOException | InterruptedException ix) {
                LOGGER.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
            }
        }
        return false;
    }

    public static int getMongodProcessId(String output, int defaultValue) {
        Pattern pattern = Pattern.compile("MongoDB starting : pid=([1234567890]+) port", 8);
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            String value = matcher.group(1);
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public static List<String> getCommandLine(MongodConfig config, ExtractedFileSet files, File dbDir) throws UnknownHostException {
        ArrayList<String> ret = new ArrayList<String>(Arrays.asList(Files.fileOf((File)files.baseDir(), (File)files.executable()).getAbsolutePath(), "--dbpath", "" + dbDir.getAbsolutePath()));
        if (config.params() != null && !config.params().isEmpty()) {
            for (String key : config.params().keySet()) {
                ret.addAll(Arrays.asList("--setParameter", String.format("%s=%s", key, config.params().get(key))));
            }
        }
        if (config.args() != null && !config.args().isEmpty()) {
            for (String key : config.args().keySet()) {
                ret.add(key);
                String val = config.args().get(key);
                if (val == null || val.isEmpty()) continue;
                ret.add(val);
            }
        }
        if (config.cmdOptions().auth()) {
            ret.add("--auth");
        } else {
            ret.add("--noauth");
        }
        if (!config.version().enabled(Feature.DISABLE_USE_PREALLOC) && config.cmdOptions().useNoPrealloc()) {
            ret.add("--noprealloc");
        }
        if (!config.version().enabled(Feature.DISABLE_USE_SMALL_FILES) && config.cmdOptions().useSmallFiles()) {
            ret.add("--smallfiles");
        }
        if (config.cmdOptions().useNoJournal() && !config.isConfigServer()) {
            ret.add("--nojournal");
        }
        if (config.cmdOptions().master()) {
            ret.add("--master");
        }
        if (config.version().enabled(Feature.STORAGE_ENGINE) && config.cmdOptions().storageEngine().isPresent()) {
            ret.add("--storageEngine");
            ret.add(config.cmdOptions().storageEngine().get());
        }
        if (config.cmdOptions().isVerbose()) {
            ret.add("-v");
        }
        Mongod.applyDefaultOptions(config, ret);
        Mongod.applyNet(config, ret);
        Storage replication = config.replication();
        if (replication.getReplSetName() != null) {
            ret.add("--replSet");
            ret.add(replication.getReplSetName());
        }
        if (replication.getOplogSize() != 0) {
            ret.add("--oplogSize");
            ret.add(String.valueOf(replication.getOplogSize()));
        }
        if (config.isConfigServer()) {
            ret.add("--configsvr");
        }
        if (config.isShardServer()) {
            ret.add("--shardsvr");
        }
        if (config.version().enabled(Feature.SYNC_DELAY)) {
            Mongod.applySyncDelay(ret, config.cmdOptions());
        }
        if (config.version().enabled(Feature.TEXT_SEARCH)) {
            Mongod.applyTextSearch(ret, config.cmdOptions());
        }
        return ret;
    }

    private static void applySyncDelay(List<String> ret, MongoCmdOptions cmdOptions) {
        int syncDelay = cmdOptions.syncDelay();
        if (!cmdOptions.useDefaultSyncDelay()) {
            ret.add("--syncdelay=" + syncDelay);
        }
    }

    private static void applyTextSearch(List<String> ret, MongoCmdOptions cmdOptions) {
        if (cmdOptions.enableTextSearch()) {
            ret.add("--setParameter");
            ret.add("textSearchEnabled=true");
        }
    }

    public static List<String> enhanceCommandLinePlattformSpecific(Distribution distribution, List<String> commands) {
        if (NUMA.isNUMA((de.flapdoodle.embed.process.config.SupportConfig)new SupportConfig(Command.MongoD), (Platform)distribution.platform())) {
            switch (distribution.platform().operatingSystem()) {
                case Linux: {
                    ArrayList<String> ret = new ArrayList<String>();
                    ret.add("numactl");
                    ret.add("--interleave=all");
                    ret.addAll(commands);
                    return ret;
                }
            }
            LOGGER.warn("NUMA Plattform detected, but not supported.");
        }
        return commands;
    }
}

