/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.distribution.Feature;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.PackageResolver;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.OS;

public class Paths
implements PackageResolver {
    private final Command command;

    public Paths(Command command) {
        this.command = command;
    }

    public DistributionPackage packageFor(Distribution distribution) {
        return DistributionPackage.of((ArchiveType)this.getArchiveType(distribution), (FileSet)this.getFileSet(distribution), (String)this.getPath(distribution));
    }

    public FileSet getFileSet(Distribution distribution) {
        String executableFileName;
        switch (distribution.platform().operatingSystem()) {
            case Linux: 
            case OS_X: 
            case Solaris: 
            case FreeBSD: {
                executableFileName = this.command.commandName();
                break;
            }
            case Windows: {
                executableFileName = this.command.commandName() + ".exe";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.platform());
            }
        }
        return FileSet.builder().addEntry(FileType.Executable, executableFileName).build();
    }

    public ArchiveType getArchiveType(Distribution distribution) {
        ArchiveType archiveType;
        switch (distribution.platform().operatingSystem()) {
            case Linux: 
            case OS_X: 
            case Solaris: 
            case FreeBSD: {
                archiveType = ArchiveType.TGZ;
                break;
            }
            case Windows: {
                archiveType = ArchiveType.ZIP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.platform());
            }
        }
        return archiveType;
    }

    public String getPath(Distribution distribution) {
        String versionStr = Paths.getVersionPart(distribution.version());
        if (distribution.platform().operatingSystem() == OS.Solaris && Paths.isFeatureEnabled(distribution, Feature.NO_SOLARIS_SUPPORT)) {
            throw new IllegalArgumentException("Mongodb for solaris is not available anymore");
        }
        ArchiveType archiveType = this.getArchiveType(distribution);
        String archiveTypeStr = this.getArchiveString(archiveType);
        String platformStr = this.getPlattformString(distribution);
        String bitSizeStr = this.getBitSize(distribution);
        if (distribution.platform().architecture().bitSize() == BitSize.B64 && distribution.platform().operatingSystem() == OS.Windows) {
            versionStr = (this.useWindows2008PlusVersion(distribution) ? "2008plus-" : "") + (this.withSsl(distribution) ? "ssl-" : "") + versionStr;
        }
        if (distribution.platform().operatingSystem() == OS.OS_X && this.withSsl(distribution)) {
            return platformStr + "/mongodb-" + platformStr + "-ssl-" + bitSizeStr + "-" + versionStr + "." + archiveTypeStr;
        }
        return platformStr + "/mongodb-" + platformStr + "-" + bitSizeStr + "-" + versionStr + "." + archiveTypeStr;
    }

    private String getArchiveString(ArchiveType archiveType) {
        String sarchiveType;
        switch (archiveType) {
            case TGZ: {
                sarchiveType = "tgz";
                break;
            }
            case ZIP: {
                sarchiveType = "zip";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ArchiveType " + archiveType);
            }
        }
        return sarchiveType;
    }

    private String getPlattformString(Distribution distribution) {
        String splatform;
        switch (distribution.platform().operatingSystem()) {
            case Linux: {
                splatform = "linux";
                break;
            }
            case Windows: {
                splatform = "win32";
                break;
            }
            case OS_X: {
                splatform = "osx";
                break;
            }
            case Solaris: {
                splatform = "sunos5";
                break;
            }
            case FreeBSD: {
                splatform = "freebsd";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.platform());
            }
        }
        return splatform;
    }

    private String getBitSize(Distribution distribution) {
        String sbitSize;
        block0 : switch (distribution.platform().architecture().bitSize()) {
            case B32: {
                IFeatureAwareVersion featuredVersion;
                if (distribution.version() instanceof IFeatureAwareVersion && (featuredVersion = (IFeatureAwareVersion)distribution.version()).enabled(Feature.ONLY_64BIT)) {
                    throw new IllegalArgumentException("this version does not support 32Bit: " + distribution);
                }
                switch (distribution.platform().operatingSystem()) {
                    case Linux: {
                        sbitSize = "i686";
                        break block0;
                    }
                    case Windows: {
                        sbitSize = "i386";
                        break block0;
                    }
                    case OS_X: {
                        sbitSize = "i386";
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Platform " + distribution.platform() + " not supported yet on 32Bit Platform");
            }
            case B64: {
                sbitSize = "x86_64";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown BitSize " + distribution.platform().architecture().bitSize());
            }
        }
        return sbitSize;
    }

    protected boolean useWindows2008PlusVersion(Distribution distribution) {
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows Server 2008 R2") || distribution.version() instanceof IFeatureAwareVersion && ((IFeatureAwareVersion)distribution.version()).enabled(Feature.ONLY_WINDOWS_2008_SERVER)) {
            return true;
        }
        return osName.contains("Windows 7");
    }

    protected boolean withSsl(Distribution distribution) {
        if ((distribution.platform().operatingSystem() == OS.Windows || distribution.platform().operatingSystem() == OS.OS_X) && distribution.version() instanceof IFeatureAwareVersion) {
            return ((IFeatureAwareVersion)distribution.version()).enabled(Feature.ONLY_WITH_SSL);
        }
        return false;
    }

    private static boolean isFeatureEnabled(Distribution distribution, Feature feature) {
        return distribution.version() instanceof IFeatureAwareVersion && ((IFeatureAwareVersion)distribution.version()).enabled(feature);
    }

    protected static String getVersionPart(Version version) {
        return version.asInDownloadPath();
    }
}

