/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.AbstractMongoConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.mongo.config.IMongosConfig;
import de.flapdoodle.embed.mongo.config.MongosSupportConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.builder.TypedProperty;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MongosConfigBuilder
extends AbstractMongoConfigBuilder<IMongosConfig> {
    protected static final TypedProperty<String> CONFIG_DB = TypedProperty.with((String)"ConfigDB", String.class);
    protected static final TypedProperty<String> RELICA_SET = TypedProperty.with((String)"ReplicaSet", String.class);
    protected Map<String, String> args = new LinkedHashMap<String, String>();

    public MongosConfigBuilder() throws IOException {
        this.property(PID_FILE).setDefault((Object)"mongos.pid");
        this.property(RELICA_SET).setDefault((Object)"");
    }

    public MongosConfigBuilder version(IFeatureAwareVersion version) {
        this.version().set((Object)version);
        return this;
    }

    public MongosConfigBuilder timeout(Timeout timeout) {
        this.timeout().set((Object)timeout);
        return this;
    }

    public MongosConfigBuilder net(Net net) {
        this.net().set((Object)net);
        return this;
    }

    public MongosConfigBuilder withLaunchArgument(String name, String value) {
        this.args.put(name, value);
        return this;
    }

    public MongosConfigBuilder cmdOptions(IMongoCmdOptions cmdOptions) {
        this.cmdOptions().set((Object)cmdOptions);
        return this;
    }

    public MongosConfigBuilder configDB(String configDB) {
        this.set(CONFIG_DB, configDB);
        return this;
    }

    public MongosConfigBuilder replicaSet(String replicaSet) {
        this.set(RELICA_SET, replicaSet);
        return this;
    }

    public IMongosConfig build() {
        IFeatureAwareVersion version = (IFeatureAwareVersion)this.version().get();
        Net net = (Net)this.net().get();
        Timeout timeout = (Timeout)this.timeout().get();
        String configDB = (String)this.get(CONFIG_DB);
        String replicaSet = (String)this.get(RELICA_SET);
        IMongoCmdOptions cmdOptions = (IMongoCmdOptions)this.get(CMD_OPTIONS);
        String pidFile = (String)this.get(PID_FILE);
        return new ImmutableMongosConfig(version, net, timeout, cmdOptions, pidFile, configDB, replicaSet, this.args);
    }

    static class ImmutableMongosConfig
    extends AbstractMongoConfigBuilder.ImmutableMongoConfig
    implements IMongosConfig {
        private final String _configDB;
        private final Map<String, String> _args;
        private final String replicaSet;

        public ImmutableMongosConfig(IFeatureAwareVersion version, Net net, Timeout timeout, IMongoCmdOptions cmdOptions, String pidFile, String configDB, String replicaSet, Map<String, String> args) {
            super(MongosSupportConfig.getInstance(), version, net, null, null, timeout, cmdOptions, pidFile);
            this._configDB = configDB;
            this.replicaSet = replicaSet;
            this._args = new LinkedHashMap<String, String>(args);
        }

        @Override
        public String getConfigDB() {
            return this._configDB;
        }

        @Override
        public String replicaSet() {
            return this.replicaSet;
        }

        @Override
        public Map<String, String> args() {
            return Collections.unmodifiableMap(this._args);
        }
    }
}

